<?php
// policy_payment_processing.php
session_start();
include("database.php");
include("session.php");

// Get user index (assume numeric)
$userindex = isset($_SESSION['userindex']) ? (int)$_SESSION['userindex'] : 0;
$user_sub_priv = isset($_SESSION['user_sub_priv']) ? (int)$_SESSION['user_sub_priv'] : 0;


?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Impact Life Insurance - Reports Dashboard</title>

  <!-- Google Fonts & Icons -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons+Round" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <style>
    :root {
      --primary-blue: #004aad;
      --secondary-blue: #0066cc;
      --light-blue: #e6f0ff;
      --dark-blue: #00337d;
      --success-green: #10b981;
      --warning-orange: #f59e0b;
      --danger-red: #ef4444;
      --text-dark: #1e293b;
      --text-medium: #475569;
      --text-light: #64748b;
      --bg-light: #f8fafc;
      --border-color: #e2e8f0;
      --shadow-sm: 0 1px 3px rgba(0, 0, 0, 0.12);
      --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
      --shadow-lg: 0 10px 25px -5px rgba(0, 0, 0, 0.1);
      --radius-sm: 6px;
      --radius-md: 10px;
      --radius-lg: 16px;
    }

    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(135deg, #f5f8ff 0%, #e6eef9 100%);
      color: var(--text-dark);
      min-height: 100vh;
      padding: 20px;
    }

    .dashboard-container {
      max-width: 1200px;
      margin: 0 auto;
    }

    .dashboard-header {
      text-align: center;
      margin-bottom: 40px;
      padding-top: 20px;
    }

    .dashboard-header h1 {
      color: var(--primary-blue);
      font-size: 2.5rem;
      font-weight: 700;
      margin-bottom: 10px;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 15px;
    }

    .dashboard-header p {
      color: var(--text-medium);
      font-size: 1.1rem;
      max-width: 600px;
      margin: 0 auto;
      line-height: 1.6;
    }

    .dashboard-grid {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
      gap: 25px;
      margin-bottom: 40px;
    }

    .report-card {
      background: white;
      border-radius: var(--radius-lg);
      padding: 30px;
      box-shadow: var(--shadow-md);
      transition: all 0.3s ease;
      border: 1px solid var(--border-color);
      position: relative;
      overflow: hidden;
    }

    .report-card:hover {
      transform: translateY(-5px);
      box-shadow: var(--shadow-lg);
      border-color: var(--primary-blue);
    }

    .report-card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 5px;
      height: 100%;
      background: var(--primary-blue);
    }

    .card-header {
      display: flex;
      align-items: center;
      margin-bottom: 20px;
    }

    .card-icon {
      width: 50px;
      height: 50px;
      border-radius: var(--radius-md);
      background: var(--light-blue);
      display: flex;
      align-items: center;
      justify-content: center;
      margin-right: 15px;
      color: var(--primary-blue);
      font-size: 1.5rem;
    }

    .card-title {
      font-size: 1.3rem;
      font-weight: 600;
      color: var(--text-dark);
    }

    .card-description {
      color: var(--text-light);
      font-size: 0.95rem;
      line-height: 1.5;
      margin-bottom: 25px;
    }

    .report-form {
      display: flex;
      flex-direction: column;
      gap: 20px;
    }

    .form-group {
      display: flex;
      flex-direction: column;
    }

    .form-group label {
      font-weight: 500;
      color: var(--text-medium);
      margin-bottom: 8px;
      font-size: 0.95rem;
    }

    .form-group select,
    .form-group input {
      padding: 12px 15px;
      border: 1px solid var(--border-color);
      border-radius: var(--radius-sm);
      font-size: 0.95rem;
      font-family: 'Inter', sans-serif;
      transition: all 0.2s;
      background-color: white;
    }

    .form-group select:focus,
    .form-group input:focus {
      outline: none;
      border-color: var(--primary-blue);
      box-shadow: 0 0 0 3px rgba(0, 74, 173, 0.1);
    }

    .generate-btn {
      background: linear-gradient(to right, var(--primary-blue), var(--secondary-blue));
      color: white;
      border: none;
      border-radius: var(--radius-sm);
      padding: 14px 20px;
      font-weight: 600;
      font-size: 1rem;
      cursor: pointer;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
      transition: all 0.3s;
      margin-top: 10px;
    }

    .generate-btn:hover {
      background: linear-gradient(to right, var(--dark-blue), var(--primary-blue));
      transform: translateY(-2px);
      box-shadow: var(--shadow-md);
    }

    .date-range-container {
      display: flex;
      gap: 15px;
    }

    .date-range-container .form-group {
      flex: 1;
    }

    .category-label {
      display: inline-block;
      padding: 5px 12px;
      background: var(--light-blue);
      color: var(--primary-blue);
      border-radius: 20px;
      font-size: 0.8rem;
      font-weight: 600;
      margin-bottom: 10px;
    }

    .footer-info {
      text-align: center;
      padding: 25px;
      color: var(--text-light);
      font-size: 0.9rem;
      border-top: 1px solid var(--border-color);
      margin-top: 30px;
      background: white;
      border-radius: var(--radius-md);
      box-shadow: var(--shadow-sm);
    }

    @media (max-width: 768px) {
      .dashboard-grid {
        grid-template-columns: 1fr;
      }
      
      .dashboard-header h1 {
        font-size: 2rem;
      }
      
      .date-range-container {
        flex-direction: column;
        gap: 15px;
      }
      
      body {
        padding: 15px;
      }
    }

    /* Loading animation for buttons */
    .loading {
      pointer-events: none;
      opacity: 0.8;
    }

    .loading::after {
      content: '';
      display: inline-block;
      width: 16px;
      height: 16px;
      border: 2px solid white;
      border-radius: 50%;
      border-top-color: transparent;
      animation: spin 1s linear infinite;
      margin-left: 10px;
    }

    @keyframes spin {
      to { transform: rotate(360deg); }
    }
  </style>
  <style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}

.blue-text {
    color: blue;
}
</style>
</head>
<?php include 'main_menu_app.php';?>
<body>
  <div class="dashboard-container">
    <div class="dashboard-header">
<h1 style="color:#ffffff;">
  <i class="fas fa-chart-line"></i> Impact Life Insurance Reports Dashboard
</h1>
<p class="text-white fw-bold">
  Generate comprehensive reports for policies, claims, payments, and agent performance.
  Select a report type below and specify date range if needed.
</p>

    </div>
<?php if ($user_sub_priv == '105') { ?>
    <div class="dashboard-grid">
      <!-- Policy Reports Card -->
      <div class="report-card">
        <span class="category-label">Policy Reports</span>
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-file-contract"></i>
          </div>
          <h3 class="card-title">Policy Analysis</h3>
        </div>
        <p class="card-description">Generate reports on active, lapsed, terminated policies, policy statements, and schedules.</p>
        
        <form class="report-form" action="backoffice_reports_eng.php" method="POST">
          <input type="hidden" name="category" value="policy">
          
          <div class="form-group">
            <label for="policy_report_type">Select Policy Report</label>
            <select name="policy_report_type" id="policy_report_type" required>
              <option value="">-- Choose a policy report --</option>
              <option value="active_policies">Active Policy Report</option>
              <option value="lapsed_policies">Lapsed Policy Report</option>
              <option value="terminated_policies">Terminated Policy Report</option>
            </select>
          </div>
          
          <div class="date-range-container">
            <div class="form-group">
              <label for="policy_date_from">Date From</label>
              <input type="date" name="policy_date_from" id="policy_date_from">
            </div>
            <div class="form-group">
              <label for="policy_date_to">Date To</label>
              <input type="date" name="policy_date_to" id="policy_date_to">
            </div>
          </div>
          
          <button type="submit" class="generate-btn">
            <i class="fas fa-download"></i> Generate Policy Report
          </button>
        </form>
      </div>
<?php } ?>
   

<?php if ($user_sub_priv == '115') { ?>

  <!-- Premium & Payments Card -->
  <div class="report-card">
    <span class="category-label">Premium & Payments</span>

    <div class="card-header">
      <div class="card-icon">
        <i class="fas fa-credit-card"></i>
      </div>
      <h3 class="card-title">Financial Reports</h3>
    </div>

    <p class="card-description">
      Reports on premium collections, outstanding payments, batch uploads, and payment history.
    </p>

    <form class="report-form" action="backoffice_reports_eng.php" method="POST">
      <input type="hidden" name="category" value="premium">

      <div class="form-group">
        <label for="premium_report_type">Select Financial Report</label>
        <select name="premium_report_type" id="premium_report_type" required>
          <option value="">-- Choose a financial report --</option>
          <option value="premium_collection">Premium Collection Report</option>
        </select>
      </div>

      <div class="date-range-container">
        <div class="form-group">
          <label for="premium_date_from">Date From</label>
          <input type="date" name="premium_date_from" id="premium_date_from">
        </div>
        <div class="form-group">
          <label for="premium_date_to">Date To</label>
          <input type="date" name="premium_date_to" id="premium_date_to">
        </div>
      </div>

      <button type="submit" class="generate-btn">
        <i class="fas fa-file-invoice-dollar"></i> Generate Financial Report
      </button>
    </form>
  </div>

<?php } ?>

<?php if ($user_sub_priv == '113' or $user_sub_priv == '112' or $user_sub_priv == '114'  ) { ?>
      <!-- Claims Reports Card -->
      <div class="report-card">
        <span class="category-label">Claims Reports</span>
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-clipboard-check"></i>
          </div>
          <h3 class="card-title">Claims Analysis</h3>
        </div>
        <p class="card-description">Generate claims register, paid claims, pending claims, and rejected claims reports.</p>
        
        <form class="report-form" action="backoffice_reports_eng.php" method="POST">
          <input type="hidden" name="category" value="claims">
          
          <div class="form-group">
            <label for="claims_report_type">Select Claims Report</label>
            <select name="claims_report_type" id="claims_report_type" required>
              <option value="">-- Choose a claims report --</option>
              <option value="claims_report">Claims Report</option>
            </select>
          </div>
               
          <div class="date-range-container">
            <div class="form-group">
              <label for="claims_date_from">Date From</label>
              <input type="date" name="claims_date_from" id="claims_date_from">
            </div>
            <div class="form-group">
              <label for="claims_date_to">Date To</label>
              <input type="date" name="claims_date_to" id="claims_date_to">
            </div>
          </div>
          
          <button type="submit" class="generate-btn">
            <i class="fas fa-chart-bar"></i> Generate Claims Report
          </button>
        </form>
      </div>
<?php } ?>

      <?php if ($user_sub_priv == '107') { ?>
      <!-- Telesales Agents Card -->
      <div class="report-card">
        <span class="category-label">Agent Performance</span>
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-user-tie"></i>
          </div>
          <h3 class="card-title">Agent Analytics</h3>
        </div>
        <p class="card-description">Performance reports for telesales agents including sales metrics and productivity analysis.</p>
        
        <form class="report-form" action="" method="POST">
          <input type="hidden" name="category" value="agent">
          
          <div class="form-group">
            <label for="agent_report_type">Select Agent Report</label>
            <select name="report_type" id="agent_report_type" required>
              <option value="">-- Choose an agent report --</option>
              <option value="agent_performance">Agent Performance Report</option>
            </select>
          </div>
          
          <div class="date-range-container">
            <div class="form-group">
              <label for="agent_date_from">Date From</label>
              <input type="date" name="date_from" id="agent_date_from">
            </div>
            <div class="form-group">
              <label for="agent_date_to">Date To</label>
              <input type="date" name="date_to" id="agent_date_to">
            </div>
          </div>
          
          <button type="submit" class="generate-btn">
            <i class="fas fa-chart-pie"></i> Generate Agent Report
          </button>
        </form>
      </div>
    </div>
<?php } ?>
    <div class="footer-info">
      <p><i class="fas fa-info-circle"></i> All reports are generated in real-time based on the latest data in the system.</p>
      <p>Need assistance? Contact the IT Support Team at support@impactlifeinsurance.com</p>
    </div>
  </div>

  <script>
    // Add loading state to buttons on form submission
    document.querySelectorAll('.report-form').forEach(form => {
      form.addEventListener('submit', function(e) {
        const button = this.querySelector('.generate-btn');
        button.classList.add('loading');
        button.innerHTML = '<i class="fas fa-spinner"></i> Generating Report...';
        
        // In a real implementation, you would handle the form submission via AJAX
        // For now, we'll just simulate a brief delay
        setTimeout(() => {
          button.classList.remove('loading');
          button.innerHTML = '<i class="fas fa-download"></i> Generate Report';
        }, 3000);
      });
    });

    // Set default date ranges (last 30 days)
    document.addEventListener('DOMContentLoaded', function() {
      const today = new Date();
      const lastMonth = new Date();
      lastMonth.setDate(today.getDate() - 30);
      
      const formatDate = (date) => date.toISOString().split('T')[0];
      
      // Set default "Date To" as today
      document.querySelectorAll('input[type="date"][id$="date_to"]').forEach(input => {
        input.value = formatDate(today);
      });
      
      // Set default "Date From" as 30 days ago
      document.querySelectorAll('input[type="date"][id$="date_from"]').forEach(input => {
        input.value = formatDate(lastMonth);
      });
    });

    // Add visual feedback when selecting report type
    document.querySelectorAll('select').forEach(select => {
      select.addEventListener('change', function() {
        if (this.value) {
          this.style.borderColor = 'var(--primary-blue)';
          this.style.boxShadow = '0 0 0 2px rgba(0, 74, 173, 0.1)';
        }
      });
    });
  </script>
</body>
</html>