<?php


function getPremiumForAdditionalLives($con, $subscriber_id, $premiums)
{

    // Connect to Database
include("database.php");  
include("session.php");


    // IMPORTANT: Do NOT include database.php here.
    // $con is already passed into the function.

    /* ----------------------------
       STEP 1: Count additional lives
    ----------------------------- */

    $query = "SELECT COUNT(subscriptions_id_addtional) AS total_count 
              FROM subscription_additionallife 
              WHERE subscriptions_id = ?";

    $stmt = $con->prepare($query);

    if (!$stmt) {
        die("Prepare failed (count additional life): " . $con->error);
    }

    $stmt->bind_param("s", $subscriber_id);
    $stmt->execute();
    $stmt->bind_result($total_count);
    $stmt->fetch();
    $stmt->close();

    $count_additional = (int)$total_count;

    /* ----------------------------
       STEP 2: If NO additional life
    ----------------------------- */

    if ($count_additional === 0) {
        return [
            "count"        => $count_additional,
            "premium_main" => $premiums,
            "premium_one"  => 0,
            "premium_two"  => 0
        ];
    }

    /* ----------------------------
       STEP 3: If there ARE additional lives
    ----------------------------- */

    $query2 = "
        SELECT premium_main_plus_one_parent, premium_main_plus_two_parents
        FROM cover_levels_view
        WHERE premium_main_life = ?
        LIMIT 1
    ";

    $stmt2 = $con->prepare($query2);

    if (!$stmt2) {
        die("Prepare failed (cover_levels_view): " . $con->error);
    }

    // d = double (decimal number)
    $stmt2->bind_param("d", $premiums);
    $stmt2->execute();
    $stmt2->bind_result($premium_main_plus_one_parent, $premium_main_plus_two_parents);
    $stmt2->fetch();
    $stmt2->close();

    return [
        "count"        => $count_additional,
        "premium_main" => $premiums,
        "premium_one"  => $premium_main_plus_one_parent,
        "premium_two"  => $premium_main_plus_two_parents
    ];
}
