<?php
// Include database connection and session management
include("database.php");

/**
 * Logs a failed login attempt into the users_logs table.
 *
 * @param mysqli $con Database connection object.
 * @param string $userindex User identifier.
 * @param string $page_path The path of the page where the failure occurred.
 * @param string $reasons Reason for the failed login.
 */
function log_failed_login($con, $userindex, $page_path, $reasons ,$data_inf) {
    // Get the current date and time
    $date_time = date('Y-m-d H:i:s');

    //if empty
   if (empty($data_inf)) {
    $data_inf = 'N/A';
}
    // Prepare the SQL query
    $log_query = "INSERT INTO users_logs (userindex, caption, logs_date, path , data_inf) 
                  VALUES (?, ?, ?, ?, ?)";
    
    // Prepare the statement
    $log_stmt = mysqli_prepare($con, $log_query);
    
    // Check if the statement was prepared successfully
    if ($log_stmt) {
        // Bind the parameters to the prepared statement
        mysqli_stmt_bind_param($log_stmt, 'sssss', $userindex, $reasons, $date_time, $page_path ,$data_inf);
        
        // Execute the statement
        if (!mysqli_stmt_execute($log_stmt)) {
            // Error handling if the execution fails
            error_log("Error executing log statement: " . mysqli_stmt_error($log_stmt));
        }
        
        // Close the statement
        mysqli_stmt_close($log_stmt);
    } else {
        // Error handling if the statement couldn't be prepared
        error_log("Error preparing log statement: " . mysqli_error($con));
    }
}
?>