<?php
// mandate_creation_platform_eng.php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include("database.php");
include("session.php");
include("mandate_creation.php");
include("crypto_functions.php");

function clean($v): string {
    return trim((string)$v);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    die("Method not allowed. Please submit the form to access this page.");
}

// userindex
$userindex = isset($_SESSION['userindex']) ? (int)$_SESSION['userindex'] : 0;

// Collect POST
$temp_policy_num = clean($_POST['policy_number'] ?? '');
$date            = clean($_POST['date'] ?? ''); // dd-mm-yyyy
$product         = clean($_POST['product'] ?? '');
$frequencyType   = clean($_POST['frequency'] ?? '');
$phoneNumber     = clean($_POST['mobile_money_number'] ?? '');
$momo_network    = clean($_POST['momo_network'] ?? '');
$amountToDebit   = clean($_POST['total_premium'] ?? '');
$id_enc          = clean($_POST['id'] ?? '');  // encrypted id from previous page

// Validate
$errors = [];

if ($temp_policy_num === '') $errors[] = "Missing policy number.";
if ($product === '')         $errors[] = "Missing product.";
if ($frequencyType === '')   $errors[] = "Missing frequency.";
if ($phoneNumber === '')     $errors[] = "Missing mobile money number.";
if ($momo_network === '')    $errors[] = "Missing MoMo network.";
if ($amountToDebit === '')   $errors[] = "Missing premium amount.";
if ($id_enc === '')          $errors[] = "Missing reference id.";

if ($date !== '' && !preg_match('/^\d{2}\-\d{2}\-\d{4}$/', $date)) {
    $errors[] = "Invalid date format. Expected dd-mm-yyyy.";
}

// validate amount numeric
$amountFloat = (float) str_replace(',', '', $amountToDebit);
if ($amountFloat <= 0) {
    $errors[] = "Invalid premium amount.";
}

if (!empty($errors)) {
    http_response_code(400);
    die("Error:<br>- " . implode("<br>- ", $errors));
}


// OPTIONAL: Convert date to yyyy-mm-dd (if you need it later)
$date_db = null;
if ($date !== '') {
    $dt = DateTime::createFromFormat('d-m-Y', $date);
    $date_db = $dt ? $dt->format('Y-m-d') : null;
}

// path you want stored
$path = "mandate_creation_payform.php";

// Call your mandate function
$result = create_mandate(
    $con,
    $userindex,
    $momo_network,
    $phoneNumber,
    $temp_policy_num,
    $frequencyType,
    $amountFloat,
    $path
);

// ✅ Extract ONLY what you want: responseCode + responseMessage
$responseCode    = $result['response']['responseCode'] ?? '';
$responseMessage = $result['response']['responseMessage'] ?? '';

/**
 * Make a clean readable message to show on the next page.
 * Example:
 * Response Code: 03
 * Message: Mandate creation pending
 */
$payment_message =
    "Response Code: " . $responseCode . "\n" .
    "Message: " . $responseMessage;


//Encrpy
//============================
    // Encrypt the data
$id_enc = encrypt($id_enc);

// URL-safe
$id_enc_url = urlencode($id_enc);
$id_msg     = urlencode($payment_message);

// Redirect properly
header("Location: mandate_creation_payform.php?id={$id_enc_url}&id_msg={$id_msg}");
exit;
?>