<?php
// Include necessary files
//Connect to Database
include("database.php");


include("session.php");

$msg 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['msg']),FILTER_SANITIZE_STRING));
$useindex 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_SESSION['useindex']),FILTER_SANITIZE_STRING));

// Initialize variables
$name = $userindex = $org_code = $org_name = $org_address = $org_tel = $org_email = $org_website = "";

// Sanitize inputs
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    //$msg = filter_input(INPUT_SERVER, 'msg', FILTER_SANITIZE_STRING);
    $name = filter_input(INPUT_POST, 'name', FILTER_SANITIZE_STRING);
    $userindex = filter_input(INPUT_POST, 'userindex', FILTER_SANITIZE_STRING);
    $org_name = filter_input(INPUT_POST, 'org_name', FILTER_SANITIZE_STRING);
    $org_address = filter_input(INPUT_POST, 'org_address', FILTER_SANITIZE_STRING);
    $org_tel = filter_input(INPUT_POST, 'org_tel', FILTER_SANITIZE_STRING);
    $org_email = filter_input(INPUT_POST, 'org_email', FILTER_VALIDATE_EMAIL);
    $org_website = filter_input(INPUT_POST, 'org_website', FILTER_VALIDATE_URL);
}

// CSRF Token Generation
session_start();
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$csrf_token = $_SESSION['csrf_token'];

$capturing_date = date("d-m-Y");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add New Organization</title>
    <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet">
    <link href="../assets/demo/demo.css" rel="stylesheet">
</head>
<body>
    <?php include 'main_menu.php'; ?>
    <style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}

</style>
    <script type="text/javascript">
window.onload = function(){ 
               
   if (form.msg.value == "") {
    return false ;
  }
      if(form.msg.value == "10$201?c") {
    alert("Submitted Successfully");
    form.msg.focus();
    return false ;
  } 

      if(form.msg.value == " 10$201?b") {
    alert("Invalid phone number");
    form.msg.focus();
    return false ;
  } 

      if(form.msg.value == "10$201?d") {
    alert("Invalid phone number.");
    form.msg.focus();
    return false ;
  } 
  
  

}
</script>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
                           <h4 class="card-title" style="color:rgb(10, 44, 234); font-weight: bold; text-align: center;">Add Organization</h4>
                            <p class="card-category">Please Complete This Form</p>
                        </div>
                        <div class="card-body">
                            <form id="form" name="form" method="POST" action="org_add_eng.php" enctype="multipart/form-data">
                                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
                                <div class="row">
                                    
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <label class="bmd-label-floating">Name</label>
                                            <input type="text" class="form-control" name="org_name" value="<?php echo htmlspecialchars($org_name); ?>" required>
                                            <input type="hidden" class="form-control" name="userindex" value="<?php echo htmlspecialchars($userindex); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <label class="bmd-label-floating">Address</label>
                                            <input type="text" class="form-control" name="org_address" value="<?php echo htmlspecialchars($org_address); ?>" required>
                                            <input type="hidden" name="msg" value="<?php echo htmlspecialchars($msg); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="bmd-label-floating">Telephone</label>
                                            <input type="text" class="form-control" name="org_tel" pattern="\d+" title="Only numbers are allowed" value="<?php echo htmlspecialchars($org_tel); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="bmd-label-floating">Website</label>
                                            <input type="url" class="form-control" name="org_website" value="<?php echo htmlspecialchars($org_website); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="bmd-label-floating">Email</label>
                                            <input type="email" class="form-control" name="org_email" value="<?php echo htmlspecialchars($org_email); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="">
                                            <label class="bmd-label-floating">Logo</label>
                                            <input type="file" id="org_logo" name="org_logo" class="form-control" accept="image/*" >
                                        </div>
                                        </div>                       

                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="bmd-label-floating">Date</label>
                                            <input type="text" class="form-control" readonly name="capturing_date" value="<?php echo htmlspecialchars($capturing_date); ?>">
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary pull-right" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">Submit</button>
                                <div class="clearfix"></div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card card-profile">
                        <div class="card-avatar">
                            <a href="#pablo">
                                <img class="img" src="images/bank.png" />
                            </a>
                        </div>
                        <div class="card-body">
                            <h6 class="card-category text-gray">Admin Name: <?php echo htmlspecialchars($name); ?></h6>
                            <h4 class="card-title">Summary</h4>
                            <p class="card-description">
                                <?php
                                $result_status = $con->query("SELECT COUNT(companyindex) AS total FROM company");
                                if ($result_status) {
                                    $row = $result_status->fetch_assoc();
                                    echo "Total Organization: " . $row['total'];
                                } else {
                                    echo "Unable to fetch data.";
                                }
                                ?>
                            </p>
                            <a href="org_report.php?sr=016!b100" class="btn btn-primary btn-round" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">View Report</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'footer.php'; ?>
</body>
</html>
