<?php
include("database.php");
include('log_functions.php');	
session_start();

// Check user session for authentication
if (!isset($_SESSION['userindex'])) {
    die("Unauthorized access.");
}

// Escape output function
function escape($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

// Sanitize and validate inputs
$product_parameters_product_index = filter_input(INPUT_POST, 'product_parameters_product_index', FILTER_SANITIZE_STRING);
$premium_main_life = filter_input(INPUT_POST, 'premium_main_life', FILTER_SANITIZE_STRING);
$premium_main_plus_one_parent = filter_input(INPUT_POST, 'premium_main_plus_one_parent', FILTER_SANITIZE_STRING);
$premium_main_plus_two_parents = filter_input(INPUT_POST, 'premium_main_plus_two_parents', FILTER_SANITIZE_STRING);
$sum_assured = filter_input(INPUT_POST, 'sum_assured', FILTER_SANITIZE_STRING);
$userindex = $_SESSION['userindex']; // From session

// Prepare insert statement
$stmt = $con->prepare("
    INSERT INTO cover_levels (
        product_index,
        premium_main_life,
        premium_main_plus_one_parent,
        premium_main_plus_two_parents,
        sum_assured,
        userindex,
        inputdate
     ) VALUES (?, ?, ?, ?, ?, ?, ?)
");

if (!$stmt) {
    error_log("Prepare failed: " . $con->error);
    die("An error occurred. Please try again later.");
}

$inputdate = date("Y-m-d H:i:s"); // Format current date

$stmt->bind_param(
    "sssssss", // 7 placeholders
    $product_parameters_product_index,
    $premium_main_life,
    $premium_main_plus_one_parent,
    $premium_main_plus_two_parents,
    $sum_assured,
    $userindex,
    $inputdate
);

// Execute the statement and handle errors securely
if ($stmt->execute()) {
    // Log action (success case)
    $page_path = 'parameters_add.php';
    $reasons = 'Record added successfully';
    $data_inf = 'N/A';
    log_failed_login($con, $userindex, $page_path, $reasons ,$data_inf);

    // Redirect on success
    header("Location: parameters_add.php?msg=10$000?c");
    exit;
} else {
    // Log detailed error internally, but show generic error to the user
    error_log("Database error: " . $stmt->error);
    die("An error occurred while processing your request. Please try again later.");
}

$stmt->close();
?>
