<?php 
// Show all errors during development (turn off in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Connect to Database
include("database.php");
require_once('crypto_functions.php');
include("session.php");

// Sanitize helper
function sanitize_input($input) {
    return htmlspecialchars(
        filter_var($input, FILTER_SANITIZE_STRING, FILTER_FLAG_NO_ENCODE_QUOTES), 
        ENT_QUOTES, 
        'UTF-8'
    );
}

// Sanitize inputs
$msg       = isset($_REQUEST['msg']) ? sanitize_input($_REQUEST['msg']) : '';
$name      = isset($_REQUEST['name']) ? sanitize_input($_REQUEST['name']) : '';
$userindex = isset($_SESSION['userindex']) ? sanitize_input($_SESSION['userindex']) : '';
$idn       = isset($_REQUEST['id']) ? sanitize_input($_REQUEST['id']) : '';

// Decrypt the ID
$id = !empty($idn) ? decrypt($idn) : '';

// Define current date
$capturing_date = date("Y-m-d H:i:s");

if (!empty($id)) {
    // Fetch parameter details
       $query = "SELECT * FROM cover_levels_view WHERE cover_level_id = ?";
    $stmt = $con->prepare($query);

    if (!$stmt) {
        die("Prepare failed: " . $con->error);
    }

    $stmt->bind_param("s", $id);
    $stmt->execute();
    $result_search = $stmt->get_result();

    if ($result_search->num_rows > 0) {
        $test_search   = $result_search->fetch_assoc();
        $product_name = trim($test_search['product_name']);
        $premium_main_life = trim($test_search['premium_main_life']);
        $premium_main_plus_one_parent = trim($test_search['premium_main_plus_one_parent']);
        $premium_main_plus_two_parents = trim($test_search['premium_main_plus_two_parents']);
        $sum_assured = trim($test_search['sum_assured']);        
        $is_active = trim($test_search['is_active']);
        // If company_name exists in table
        //$company_name  = isset($test_search['company_name']) ? trim($test_search['company_name']) : "N/A";
    } else {
        die("Error: Parameter not found.");
    }
    $stmt->close();
} else {
    die("Error: Invalid ID.");
}


//validation checks
if($is_active == 1) {
$is_active_ans = 'Active';
} else {
$is_active_ans = 'Inactive';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <title>CAPTURING CONFIRMATION PAGE</title>
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  <link href="../assets/demo/demo.css" rel="stylesheet" />
</head>

<?php include 'main_menu.php' ?>

<style>
body {
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9;
}
body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5;
    z-index: -1;
}
</style>

<?php $capturing_date = date("d-m-Y"); ?>

<div class="content">
  <div class="container-fluid">
    <div class="row">

      <div class="col-md-8">
        <div class="card">
          <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
            <h4 class="card-title" style="color:rgb(10, 44, 234); font-weight: bold; text-align: center;">Delete Parameters</h4>
            <p class="card-category">Please Confirm the Details</p>
          </div>
          <div class="card-body">

            <div class="row">
              <div class="col-md-5">
                <div class="form-group">
                  <label class="bmd-label-floating">Product Name: <?php echo htmlspecialchars($product_name); ?></label>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group">
                  <label class="bmd-label-floating">Mail Life Premium: <?php echo htmlspecialchars($premium_main_life); ?></label>
                </div>
              </div>

              <div class="col-md-4">
                <div class="form-group">
                  <label class="bmd-label-floating">Sum Assured: <?php echo htmlspecialchars($sum_assured); ?></label>
                </div>
              </div>
            </div>

            <div class="col-md-4">
                <div class="form-group">
                  <label class="bmd-label-floating">Status: <?php echo htmlspecialchars($is_active_ans); ?></label>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label class="bmd-label-floating"></label>
                </div>
              </div>

            <div class="row">
              <div class="col-md-12">
                <div class="form-group">
                  <label>Confirm</label>
                  <div class="form-group">
                    <label class="bmd-label-floating">Are you sure you want to proceed with the details above?</label>
                  </div>
                </div>
              </div>
            </div>

            <div align="right">
              <a href='parameters_delete.php?idcode=<?php echo urlencode(encrypt($id)); ?>'>
                <img src="images/yes.png" width="47" height="38" alt="yes">
              </a>
              &nbsp;&nbsp;&nbsp;
              <a href='parameters_report.php?sr=018!b112'>
                <img src="images/no.jpg" width="47" height="38" alt="no">
              </a>
            </div>

          </div>
        </div>
      </div>

      <!-- Summary Section -->
            <div class="col-md-4">
                <div class="card card-profile">
                    <div class="card-avatar">
                        <a href="#">
                            <img class="img" src="images/edit_butt.png" />
                        </a>
                    </div>
                    <div class="card-body">
                        <h6 class="card-category text-gray">Admin Name: <?php echo htmlspecialchars($name); ?></h6>
                        <h4 class="card-title">Summary</h4>
                        <p class="card-description">
                        <?php
                        $stmt = $con->prepare("SELECT COUNT(is_active) AS count_active FROM cover_levels 
                        where is_active = 1 ");
                        $stmt->execute();
                        $stmt->bind_result($count_active);
                        $stmt->fetch();
                        echo 'Total Paraemters: ' . htmlspecialchars($count_active);
                        $stmt->close();
                        ?>
                        </p>
                        <a href="parameters_report.php?sr=018!b112" class="btn btn-primary btn-round" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">View Report</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
<?php 
