<?php
// Connect to Database
include("database.php");
require_once('laspse_function.php');
include("session.php");

// Get policy number from URL parameter
$policy_number = isset($_GET['policy_number']) ? mysqli_real_escape_string($con, $_GET['policy_number']) : '';
$export_type = isset($_GET['export']) ? $_GET['export'] : '';

// Handle export requests
if ($export_type) {
    generateExport($export_type, $con, $policy_number);
    exit();
}

// Function to generate exports
function generateExport($type, $con, $policy_number) {
    if (empty($policy_number)) {
        die("Policy number is required for export.");
    }
    
    // Get policy details
    $policy_query = "SELECT * FROM policy_details_view WHERE policy_number = '$policy_number' LIMIT 1";
    $policy_result = mysqli_query($con, $policy_query);
    $policy_details = mysqli_fetch_assoc($policy_result);
    
    if (!$policy_details) {
        die("Policy not found.");
    }
    
    // Get ALL payment history for this policy
    $query = "SELECT * FROM premium_collection_view WHERE policy_number = '$policy_number' 
              ORDER BY STR_TO_DATE(trans_date, '%m/%d/%Y') DESC";
    
    $result = mysqli_query($con, $query);
    
    if ($type === 'excel') {
        exportToExcel($result, $policy_details);
    } elseif ($type === 'pdf') {
        exportToPDF($result, $policy_details);
    }
}

function exportToExcel($result, $policy_details) {
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="payment_history_' . $policy_details['policy_number'] . '_' . date('Y-m-d') . '.xls"');
    
    echo '<table border="1">';
    echo '<tr><th colspan="5" style="background:#6ec1e4; color:white; font-size:16px; padding:10px;">PAYMENT HISTORY REPORT</th></tr>';
    
    // Policy Information
    echo '<tr><td colspan="5" style="background:#f2f2f2; padding:10px;">';
    echo '<strong>POLICY INFORMATION</strong><br>';
    echo 'Policy Number: ' . htmlspecialchars($policy_details['policy_number']) . '<br>';
    echo 'Policy Holder: ' . htmlspecialchars($policy_details['full_name']) . '<br>';
    echo 'Product: ' . htmlspecialchars($policy_details['product_name']) . '<br>';
    echo 'Status: ' . htmlspecialchars($policy_details['policy_status']) . '<br>';
    echo 'Premium Amount: GHS ' . number_format($policy_details['set_premium'], 2);
    echo '</td></tr>';
    
    echo '<tr>';
    echo '<th style="background:#6ec1e4; color:white; padding:8px;">#</th>';
    echo '<th style="background:#6ec1e4; color:white; padding:8px;">Transaction Date</th>';
    echo '<th style="background:#6ec1e4; color:white; padding:8px;">Amount (GHS)</th>';
    echo '<th style="background:#6ec1e4; color:white; padding:8px;">Payment Reference</th>';
    echo '<th style="background:#6ec1e4; color:white; padding:8px;">Payment Batch ID</th>';
    echo '</tr>';
    
    $total_amount = 0;
    $record_count = 0;
    $counter = 1;
    
    while ($row = mysqli_fetch_assoc($result)) {
        echo '<tr>';
        echo '<td>' . $counter++ . '</td>';
        echo '<td>' . htmlspecialchars($row['trans_date']) . '</td>';
        echo '<td>' . number_format($row['amount'], 2) . '</td>';
        echo '<td>' . htmlspecialchars($row['payment_reference']) . '</td>';
        echo '<td>' . htmlspecialchars($row['payment_batch_id']) . '</td>';
        echo '</tr>';
        
        $total_amount += $row['amount'];
        $record_count++;
    }
    
    if ($record_count == 0) {
        echo '<tr><td colspan="5" style="text-align:center; padding:20px;">No payment records found</td></tr>';
    }
    
    // Summary row
    echo '<tr style="background-color:#e8f4fd; font-weight:bold;">';
    echo '<td colspan="2" style="text-align:right;">Total:</td>';
    echo '<td>GHS ' . number_format($total_amount, 2) . '</td>';
    echo '<td colspan="2">' . $record_count . ' payment(s)</td>';
    echo '</tr>';
    
    echo '</table>';
    exit();
}

function exportToPDF($result, $policy_details) {
    // For PDF export - using simple HTML as fallback
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="payment_history_' . $policy_details['policy_number'] . '_' . date('Y-m-d') . '.xls"');
    
    echo '<table border="1">';
    echo '<tr><th colspan="5" style="background:#6ec1e4; color:white; font-size:16px; padding:10px;">PAYMENT HISTORY REPORT</th></tr>';
    
    // Policy Information
    echo '<tr><td colspan="5" style="background:#f2f2f2; padding:10px;">';
    echo '<strong>POLICY INFORMATION</strong><br>';
    echo 'Policy Number: ' . htmlspecialchars($policy_details['policy_number']) . '<br>';
    echo 'Policy Holder: ' . htmlspecialchars($policy_details['full_name']) . '<br>';
    echo 'Product: ' . htmlspecialchars($policy_details['product_name']) . '<br>';
    echo 'Status: ' . htmlspecialchars($policy_details['policy_status']);
    echo '</td></tr>';
    
    echo '<tr>';
    echo '<th style="background:#6ec1e4; color:white; padding:8px;">Transaction Date</th>';
    echo '<th style="background:#6ec1e4; color:white; padding:8px;">Amount (GHS)</th>';
    echo '<th style="background:#6ec1e4; color:white; padding:8px;">Payment Reference</th>';
    echo '<th style="background:#6ec1e4; color:white; padding:8px;">Payment Batch ID</th>';
    echo '</tr>';
    
    $total_amount = 0;
    $record_count = 0;
    
    while ($row = mysqli_fetch_assoc($result)) {
        echo '<tr>';
        echo '<td>' . htmlspecialchars($row['trans_date']) . '</td>';
        echo '<td>' . number_format($row['amount'], 2) . '</td>';
        echo '<td>' . htmlspecialchars($row['payment_reference']) . '</td>';
        echo '<td>' . htmlspecialchars($row['payment_batch_id']) . '</td>';
        echo '</tr>';
        
        $total_amount += $row['amount'];
        $record_count++;
    }
    
    if ($record_count == 0) {
        echo '<tr><td colspan="4" style="text-align:center; padding:20px;">No payment records found</td></tr>';
    }
    
    echo '<tr style="background-color:#e8f4fd; font-weight:bold;">';
    echo '<td colspan="1" style="text-align:right;">Total:</td>';
    echo '<td>GHS ' . number_format($total_amount, 2) . '</td>';
    echo '<td colspan="2">' . $record_count . ' payment(s)</td>';
    echo '</tr>';
    
    echo '</table>';
    exit();
}

// Main code for displaying the report
if (empty($policy_number)) {
    die("<div class='alert alert-danger'>Error: Policy number is required. Please provide a policy number in the URL.</div>");
}

// Get policy details
$policy_query = "SELECT * FROM policy_details_view WHERE policy_number = '$policy_number' LIMIT 1";
$policy_result = mysqli_query($con, $policy_query);

if (!$policy_result || mysqli_num_rows($policy_result) == 0) {
    die("<div class='alert alert-danger'>Error: Policy not found. Please check the policy number.</div>");
}

$policy_details = mysqli_fetch_assoc($policy_result);

// Get ALL payment history for this policy (no date filtering)
$query = "SELECT * FROM premium_collection_view WHERE policy_number = '$policy_number' 
          ORDER BY STR_TO_DATE(trans_date, '%m/%d/%Y') DESC";

$payment_result = mysqli_query($con, $query);

$total_amount = 0;
$record_count = 0;
$payment_records = [];

if ($payment_result && mysqli_num_rows($payment_result) > 0) {
    while ($row = mysqli_fetch_assoc($payment_result)) {
        $payment_records[] = $row;
        $total_amount += $row['amount'];
        $record_count++;
    }
}

// Calculate expected payments
$expected_payments = 0;
$expected_amount = 0;
if (!empty($payment_records)) {
    $first_payment = $payment_records[count($payment_records)-1];
    $first_date = DateTime::createFromFormat('m/d/Y', $first_payment['trans_date']);
    $current_date = new DateTime();
    
    if ($first_date) {
        $interval = $first_date->diff($current_date);
        $months_passed = ($interval->y * 12) + $interval->m;
        $expected_payments = max($months_passed + 1, count($payment_records));
        $expected_amount = $expected_payments * $policy_details['set_premium'];
    }
}

// Today's date for lapse check
$asAtDate = date('Y-m-d');

// Check policy lapse status
$chk = abraboIsPolicyLapsed($con, $policy_number, $asAtDate);

$is_policy_active = 0;
$policy_status_text = 'LAPSED';

if (($chk['ok'] ?? false) && ($chk['is_lapsed'] === false)) {
    $is_policy_active = 1;
    $policy_status_text = 'ACTIVE';
}

// Policy status validation
if (in_array($policy_statusn, ['CANCELLED', 'TERMINATED'], true)) {
    // Respect explicit terminal statuses
    $policy_status = $policy_statusn;
} else {
    // Derive status from lapse check (ACTIVE / LAPSED)
    $policy_status = $policy_status_text;
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment History - <?php echo htmlspecialchars($policy_details['policy_number']); ?></title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .card-header-primary {
            background: linear-gradient(135deg, #6ec1e4 0%, #1a73e8 100%);
            color: white;
            text-align: center;
            padding: 20px;
        }
        .card-title {
            color: white;
            font-weight: bold;
            text-align: center;
            font-size: 24px;
        }
        .card-category {
            color: rgba(255, 255, 255, 0.8);
            font-size: 16px;
        }
        .policy-info-card {
            background: white;
            border-radius: 10px;
            padding: 25px;
            margin-bottom: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            border-left: 5px solid #6ec1e4;
        }
        .policy-info-label {
            font-weight: 600;
            color: #555;
            font-size: 14px;
            margin-bottom: 5px;
        }
        .policy-info-value {
            font-size: 16px;
            color: #333;
            margin-bottom: 15px;
        }
        .summary-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .summary-title {
            color: #1a73e8;
            font-weight: 600;
            margin-bottom: 15px;
            font-size: 18px;
        }
        .summary-value {
            font-size: 24px;
            font-weight: bold;
            color: #333;
        }
        .summary-label {
            font-size: 14px;
            color: #666;
        }
        .table-container {
            margin-top: 20px;
            background: white;
            border-radius: 10px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .table th {
            background-color: #f8f9fa;
            color: #333;
            font-weight: 600;
            border-top: none;
        }
        .table td {
            vertical-align: middle;
        }
        .export-buttons {
            margin-bottom: 25px;
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .btn-export {
            margin-right: 10px;
            margin-bottom: 10px;
        }
        .no-data {
            text-align: center;
            padding: 50px;
            color: #666;
        }
        .progress-container {
            background: white;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .progress {
            height: 10px;
            margin-top: 10px;
        }
        .payment-status {
            display: flex;
            justify-content: space-between;
            margin-top: 5px;
        }
        .payment-status span {
            font-size: 12px;
            color: #666;
        }
    </style>
</head>
<body>
    <?php include 'main_menu.php'; ?>
    <style>
        body {
            background-image: url('images/ayo_banner4.png');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
        }
    </style>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
                            <h4 class="card-title">Payment History Report</h4>
                            <p class="card-category">Complete payment history for policy holder</p>
                        </div>
                        <div class="card-body">
                            <!-- Policy Information -->
                            <div class="policy-info-card">
                                <h4 class="mb-4" style="color: #1a73e8;">
                                    <i class="fas fa-user-circle"></i> Policy Holder Information
                                </h4>
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="policy-info-label">Policy Number</div>
                                        <div class="policy-info-value">
                                            <strong><?php echo htmlspecialchars($policy_details['policy_number']); ?></strong>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="policy-info-label">Full Name</div>
                                        <div class="policy-info-value"><?php echo htmlspecialchars($policy_details['full_name']); ?></div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="policy-info-label">Date of Birth</div>
                                        <div class="policy-info-value"><?php echo htmlspecialchars($policy_details['date_of_birth']); ?></div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="policy-info-label">Gender</div>
                                        <div class="policy-info-value"><?php echo htmlspecialchars($policy_details['gender']); ?></div>
                                    </div>
                                </div>
                                <div class="row mt-3">
                                    <div class="col-md-3">
                                        <div class="policy-info-label">Mobile Money Number</div>
                                        <div class="policy-info-value"><?php echo htmlspecialchars($policy_details['mobile_money_number']); ?></div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="policy-info-label">Network</div>
                                        <div class="policy-info-value"><?php echo htmlspecialchars($policy_details['momo_network']); ?></div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="policy-info-label">Product Name</div>
                                        <div class="policy-info-value"><?php echo htmlspecialchars($policy_details['product_name']); ?></div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="policy-info-label">Policy Status</div>
                                        <div class="policy-info-value">
                                            <?php 
                                            $status_class = ($policy_status == 'ACTIVE') ? 'badge bg-success' : 'badge bg-warning';
                                            ?>
                                            <span class="<?php echo $status_class; ?>">
                                                <?php echo htmlspecialchars($policy_status); ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Payment Summary Cards -->
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="summary-card">
                                        <div class="summary-title">Monthly Premium</div>
                                        <div class="summary-value">GHS <?php echo number_format($policy_details['set_premium'], 2); ?></div>
                                        <div class="summary-label">Fixed Amount</div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="summary-card">
                                        <div class="summary-title">Total Payments</div>
                                        <div class="summary-value"><?php echo $record_count; ?></div>
                                        <div class="summary-label">Transactions</div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="summary-card">
                                        <div class="summary-title">Total Paid</div>
                                        <div class="summary-value">GHS <?php echo number_format($total_amount, 2); ?></div>
                                        <div class="summary-label">Amount</div>
                                    </div>
                                </div>
                                <div class="col-md-3">                                    
                                </div>
                            </div>

                            <!-- Payment Progress -->
                            <?php if ($expected_payments > 0): ?>
                            <div class="progress-container">
                                <h5 class="mb-3" style="color: #1a73e8;">
                                    <i class="fas fa-chart-line"></i> Payment Progress
                                </h5>
                                <div class="payment-status">
                                    <span>Paid: <?php echo $record_count; ?> payments</span>
                                    <span>Expected: <?php echo $expected_payments; ?> payments</span>
                                </div>
                                <div class="progress">
                                    <?php 
                                    $progress_percentage = min(100, ($record_count / $expected_payments) * 100);
                                    $progress_class = ($progress_percentage >= 80) ? 'bg-success' : 
                                                     (($progress_percentage >= 50) ? 'bg-warning' : 'bg-danger');
                                    ?>
                                    <div class="progress-bar <?php echo $progress_class; ?>" 
                                         role="progressbar" 
                                         style="width: <?php echo $progress_percentage; ?>%"
                                         aria-valuenow="<?php echo $progress_percentage; ?>" 
                                         aria-valuemin="0" 
                                         aria-valuemax="100">
                                    </div>
                                </div>
                                <div class="payment-status mt-2">
                                    <span>GHS <?php echo number_format($total_amount, 2); ?> paid</span>
                                    <span>GHS <?php echo number_format($expected_amount, 2); ?> expected</span>
                                </div>
                            </div>
                            <?php endif; ?>

                            <!-- Export Buttons -->
                            <div class="export-buttons">
                                <h5 style="color: #1a73e8; margin-bottom: 15px;">
                                    <i class="fas fa-download"></i> Export Report
                                </h5>
                                <div>
                                    <a href="?export=excel&policy_number=<?php echo urlencode($policy_number); ?>" 
                                       class="btn btn-success btn-export">
                                        <i class="fas fa-file-excel"></i> Export to Excel
                                    </a>
                                    <a href="?export=pdf&policy_number=<?php echo urlencode($policy_number); ?>" 
                                       class="btn btn-danger btn-export">
                                        <i class="fas fa-file-pdf"></i> Export to PDF
                                    </a>
                                    <button onclick="window.print()" class="btn btn-secondary btn-export">
                                        <i class="fas fa-print"></i> Print Report
                                    </button>
                                </div>
                            </div>

                            <!-- Payment History Table -->
                            <div class="table-container">
                                <h4 class="mb-4" style="color: #1a73e8;">
                                    <i class="fas fa-history"></i> Payment History
                                    <small class="text-muted">(All payments for policy <?php echo htmlspecialchars($policy_details['policy_number']); ?>)</small>
                                </h4>
                                
                                <?php if (!empty($payment_records)): ?>
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Transaction Date</th>
                                                    <th>Amount (GHS)</th>
                                                    <th>Payment Reference</th>
                                                    <th>Payment Batch ID</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php 
                                                $counter = 1;
                                                foreach ($payment_records as $record): 
                                                ?>
                                                <tr>
                                                    <td><?php echo $counter++; ?></td>
                                                    <td><?php echo htmlspecialchars($record['trans_date']); ?></td>
                                                    <td><strong>GHS <?php echo number_format($record['amount'], 2); ?></strong></td>
                                                    <td><?php echo htmlspecialchars($record['payment_reference']); ?></td>
                                                    <td>
                                                        <span class="badge bg-info">
                                                            <?php echo htmlspecialchars($record['payment_batch_id']); ?>
                                                        </span>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                            <tfoot>
                                                <tr style="background-color: #f8f9fa; font-weight: bold;">
                                                    <td colspan="2" class="text-end">Total:</td>
                                                    <td>GHS <?php echo number_format($total_amount, 2); ?></td>
                                                    <td colspan="2"><?php echo $record_count; ?> payment(s)</td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                <?php else: ?>
                                    <div class="no-data">
                                        <i class="fas fa-receipt fa-3x mb-3 text-muted"></i>
                                        <h4>No Payment Records Found</h4>
                                        <p>No payment history available for this policy holder.</p>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <!-- Report Footer -->
                            <div class="row mt-4">
                                <div class="col-md-12">
                                    <div class="alert alert-info">
                                        <h5><i class="fas fa-info-circle"></i> Report Information</h5>
                                        <ul class="mb-0">
                                            <li>Policy Number: <?php echo htmlspecialchars($policy_details['policy_number']); ?></li>
                                            <li>Report Generated: <?php echo date('Y-m-d H:i:s'); ?></li>
                                            <li>Total Records: <?php echo $record_count; ?> payment(s)</li>
                                            <li>Total Amount: GHS <?php echo number_format($total_amount, 2); ?></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Update page title with policy number
        document.addEventListener('DOMContentLoaded', function() {
            const policyNumber = "<?php echo htmlspecialchars($policy_details['policy_number']); ?>";
            document.title = "Payment History - " + policyNumber;
        });
    </script>
</body>
</html>

<?php
// Close database connection
if (isset($con)) {
    mysqli_close($con);
}
?>