<?php
//Connect to Database
include("database.php");
require_once('crypto_functions.php');
include("session.php");

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// -------------------------
// Get + decrypt id
// -------------------------
$idn = htmlspecialchars(
    filter_var(mysqli_real_escape_string($con, $_REQUEST['id'] ?? ''), FILTER_SANITIZE_STRING)
);

$id = decrypt($idn);

// ✅ policyholder_id should be int (do NOT urlencode)
$policyholder_id = (int)$id;

// -------------------------
// Fetch policy details
// -------------------------
$full_name_main = '';
$policy_number  = '';
$product_name   = '';

$stmt = $con->prepare("
    SELECT 
        policyholder_id,
        full_name,                
        policy_number,
        product_name                         
    FROM policy_details_view
    WHERE policyholder_id = ?
");

if (!$stmt) {
    die("Prepare failed: " . $con->error);
}

$stmt->bind_param("i", $policyholder_id);
$stmt->execute();
$result_search = $stmt->get_result();

if ($result_search->num_rows > 0) {
    $existing_data   = $result_search->fetch_assoc();
    $full_name_main  = htmlspecialchars($existing_data['full_name'] ?? '', ENT_QUOTES, 'UTF-8');
    $policy_number   = htmlspecialchars($existing_data['policy_number'] ?? '', ENT_QUOTES, 'UTF-8');
    $product_name    = htmlspecialchars($existing_data['product_name'] ?? '', ENT_QUOTES, 'UTF-8');
    $id = (int)($existing_data['policyholder_id'] ?? 0);
}
$stmt->close();

// -------------------------
// (Optional) DEBUG: confirm POST is working
// Remove later
// -------------------------
/*
if (isset($_POST['submit_endorsement'])) {
    echo "<pre>";
    print_r($_POST);
    echo "</pre>";
}
*/
?>

<?php include 'main_menu_app.php'; ?>

<style>
    body {
        background-image: url('images/ayo_banner4.png');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        background-attachment: fixed;
        opacity: 0.9;
    }

    body::before {
        content: "";
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-image: url('images/ayo_banner4.png');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        background-attachment: fixed;
        opacity: 0.5;
        z-index: -1;
    }

    .blue-text { color: blue; }
</style>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">

                <div class="card search-card">

                    <!-- Header (Template A) -->
                    <div class="card-header card-header-primary"
                         style="background:#6ec1e4; color:white; text-align:center; padding:15px;">
                        <h4 class="card-title">
                            <i class="fas fa-file-signature"></i> Policy Endorsement
                        </h4>
                        <p class="card-category">
                            Endorsement request details
                        </p>
                    </div>

                    <!-- Form Body -->
                    <div class="card-body">

                        <!-- ✅ POST-ready form (names + submit type fixed) -->
                        <form method="POST" action="policy_endorsements.php">

                            <!-- Hidden values you want to submit -->
                            <input type="hidden" name="id" value="<?php echo htmlspecialchars((string)$id, ENT_QUOTES, 'UTF-8'); ?>">
                            <input type="hidden" name="policy_number" value="<?php echo htmlspecialchars($policy_number ?? '', ENT_QUOTES, 'UTF-8'); ?>">

                            <div class="row">

                                <!-- Policy Number -->
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><strong>Policy Number</strong></label>
                                        <input type="text"
                                               name="policy_number_display"
                                               class="form-control"
                                               value="<?php echo htmlspecialchars($policy_number ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                                               readonly>
                                    </div>
                                </div>

                                <!-- Full Name -->
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><strong>Full Name</strong></label>
                                        <input type="text"
                                               name="full_name"
                                               class="form-control"
                                               value="<?php echo htmlspecialchars($full_name_main ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                                               readonly>
                                    </div>
                                </div>

                                <!-- Product -->
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><strong>Product</strong></label>
                                        <input type="text"
                                               name="product_name"
                                               class="form-control"
                                               value="<?php echo htmlspecialchars($product_name ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                                               readonly>
                                    </div>
                                </div>

                            </div>

                            <div class="row mt-3">

                                <!-- Endorsement Type Dropdown -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><strong>Endorsement Type</strong></label>
                                        <select class="form-control" name="endorsement_type" required>
                                            <option value="">-- Select Endorsement Type --</option>
                                            <option value="Frequency">Frequency</option>
                                            <option value="Mobile Wallet Number">Mobile Wallet Number</option>
                                            <option value="Telco">Telco</option>
                                            <option value="Premium">Premium</option>
                                            <option value="Main Life Name">Main Life Name</option>
                                            <option value="Main Life Dob">Main Life Dob</option>
                                            <option value="Addtional Life Name">Addtional Life Name</option>
                                            <option value="Additional Dob">Additional Dob</option>
                                            <option value="Additional Relationship">Additional Relationship</option>
                                            <option value="Beneficiary Name">Beneficiary Name</option>
                                            <option value="Beneficiary Dob">Beneficiary Dob</option>
                                            <option value="Beneficiary Relationship">Beneficiary Relationship</option>
                                        </select>
                                    </div>
                                </div>

                                <!-- Effective Date -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><strong>Effective Date</strong></label>
                                        <input type="date"
                                               name="effective_date"
                                               class="form-control"
                                               required>
                                    </div>
                                </div>

                            </div>

                            <div class="row mt-3">

                                <!-- Remarks -->
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label><strong>Remarks</strong></label>
                                        <textarea class="form-control"
                                                  name="remarks"
                                                  rows="3"
                                                  placeholder="Provide additional details if any"
                                                  required></textarea>
                                    </div>
                                </div>

                            </div>

                            <!-- Buttons -->
                            <div class="row mt-4">
                                <div class="col-md-12 text-center">
                                    <!-- ✅ must be submit to post -->
                                    <button type="submit" name="submit_endorsement" class="btn btn-primary">
                                        <i class="fas fa-save"></i> Proceed
                                    </button>
                                    <button type="reset" class="btn btn-secondary">
                                        <i class="fas fa-times"></i> Clear
                                    </button>
                                </div>
                            </div>

                        </form>

                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
