<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Connect to Database
include("database.php");
require_once('crypto_functions.php');

// Sanitize helper
function sanitize_input($input) {
    return htmlspecialchars(filter_var($input, FILTER_UNSAFE_RAW, FILTER_FLAG_NO_ENCODE_QUOTES), ENT_QUOTES, 'UTF-8');
}

// Sanitize inputs
$msg = isset($_REQUEST['msg']) ? sanitize_input($_REQUEST['msg']) : '';
$name = isset($_REQUEST['name']) ? sanitize_input($_REQUEST['name']) : '';
$userindex = isset($_REQUEST['userindex']) ? sanitize_input($_REQUEST['userindex']) : '';
$idn = isset($_REQUEST['id']) ? sanitize_input($_REQUEST['id']) : '';

// Decrypt the data
$id = !empty($idn) ? decrypt($idn) : null;

// Initialize defaults
$product_name = $product_description = $product_num_code = $product_num_date = $product_num_gen = "";

// Validate and search for product
if (!empty($id)) {
    $query = "SELECT * FROM product WHERE product_index = ?";
    $stmt = $con->prepare($query);
    $stmt->bind_param("s", $id);
    $stmt->execute();
    $result_search = $stmt->get_result();

    if ($result_search->num_rows > 0) {
        $test_search = $result_search->fetch_assoc();
        $product_name = trim($test_search['product_name']);
        $product_description = trim($test_search['product_description']);
        $product_num_code = trim($test_search['product_num_code']);
        $product_num_date = trim($test_search['product_num_date']);
        $product_num_gen = trim($test_search['product_num_gen']);
    } else {
        die("Error: Product not found.");
    }
    $stmt->close();
}

$capturing_date = date("d-m-Y");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <title>CAPTURING CONFIRMATION PAGE</title>
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  <link href="../assets/demo/demo.css" rel="stylesheet" />
</head>
<?php include 'main_menu.php' ?>

<style>
body {
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9;
}
body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5;
    z-index: -1;
}
</style>

<div class="content">
  <div class="container-fluid">
    <div class="row">
      <!-- Main Card -->
      <div class="col-md-8">
        <div class="card">
          <div class="card-header card-header-primary" style="background:#6ec1e4;color:white;text-align:center;padding:15px;">
            <h4 class="card-title" style="color:rgb(10,44,234);font-weight:bold;">Delete Product</h4>
            <p class="card-category">Please confirm the details below</p>
          </div>
          <div class="card-body">
            <form>
              <div class="row">
                <div class="col-md-5">
                  <label>Name: <?php echo htmlspecialchars($product_name); ?></label>
                </div>
                <div class="col-md-3">
                  <label>Description: <?php echo htmlspecialchars($product_description); ?></label>
                </div>
                <div class="col-md-4">
                  <label>Num Setup: <?php echo htmlspecialchars($product_num_code.$product_num_date.$product_num_gen); ?></label>
                </div>
              </div>

              <div class="row">
                <div class="col-md-12">
                  <label>Confirm: Are you sure you want to proceed with the details above?</label>
                </div>
              </div>

              <div align="right">
                <a href='product_delete.php?idcode=<?php echo htmlspecialchars($id); ?>'><img src="images/yes.png" width="47" height="38" alt="yes"></a>
                &nbsp;&nbsp;&nbsp;
                <a href='product_report.php?sr=018!b110'><img src="images/no.jpg" width="47" height="38" alt="no"></a>
              </div>
            </form>
          </div>
        </div>
      </div>

      <!-- Sidebar -->
      <div class="col-md-4">
        <div class="card card-profile">
          <div class="card-avatar">
            <a href="#"><img class="img" src="images/product.jpg" /></a>
          </div>
          <div class="card-body">
            <h6 class="card-category text-gray">Admin Name: <?php echo htmlspecialchars($name); ?></h6>
            <h4 class="card-title">Summary</h4>
            <p class="card-description">
              <?php
              $stmt = $con->prepare("SELECT COUNT(product_index) AS count_active FROM product");
              $stmt->execute();
              $stmt->bind_result($count_active);
              $stmt->fetch();
              echo 'Total Products: ' . htmlspecialchars($count_active);
              $stmt->close();
              ?>
            </p>
            <a href="product_report.php?sr=018!b110" class="btn btn-primary btn-round" style="background:#6ec1e4;color:white;padding:10px;">View Report</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
</body>
</html>
