<?php 
//include("session.php");

//Connect to Database
include("database.php");
require_once('crypto_functions.php');



$msg 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['msg']),FILTER_SANITIZE_STRING));
$sr 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['sr']),FILTER_SANITIZE_STRING));

// Decrypt the input (ensure proper validation and sanitization based on your decryption method)
$encrypted_string = $_REQUEST['urc'];
$decrypted_string = '';

if (!empty($encrypted_string)) {
    $decrypted_string = $encrypted_string; // Replace with actual decryption logic if applicable
}


// Sanitize user input using prepared statements
$searchallitems = htmlspecialchars($decrypted_string, ENT_QUOTES, 'UTF-8');

if (!empty($searchallitems)) {
    $Query = "SELECT * FROM product 
              WHERE product_name LIKE ? 
              ORDER BY product_index DESC";
    $stmt = $con->prepare($Query);
    $search_param = '%' . $searchallitems . '%';
    $stmt->bind_param("s", $search_param);
} else {
    $Query = "SELECT * FROM product 
              ORDER BY product_index DESC";
    $stmt = $con->prepare($Query);
}

$stmt->execute();
$result = $stmt->get_result();

?>










<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <link rel="apple-touch-icon" sizes="76x76" href="../assets/img/apple-icon.png">
  <link rel="icon" type="image/png" href="../assets/img/favicon.png">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>
VIEW PRODUCTS REPORT
  </title>
  <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
  <!--     Fonts and icons     -->

  <!-- CSS Files -->
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  <!-- CSS Just for demo purpose, don't include it in your project -->
  <link href="../assets/demo/demo.css" rel="stylesheet" />

</head>

<?php include 'main_menu.php' ?>

<style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}

</style>
<script type="text/javascript">
window.onload = function(){ 
               
   if (form.msg.value == "") {
    return false ;
  }
      if(form.msg.value == "10$205?c") {
    alert("Updated Successfully");
    form.msg.focus();
    return false ;
  } 
  

  if(form.msg.value == "10$206?c") {
    alert("Deleted Successfully");
    form.msg.focus();
    return false ;
  } 
  

}
</script>

<form id="form" name="form" method="POST" action="" enctype="multipart/form-data">
<input type="hidden" name="msg" value="<?php echo htmlspecialchars($msg); ?>">
</form>

<div class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-md-12">
              <div class="card">
               <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
                 <h4 class="card-title" style="color:rgb(10, 44, 234); font-weight: bold; text-align: center;">View Product Report</h4>
				   <p class="card-category">
            <a href="product_report.php?sr=018!b110"id="export_button" class="btn btn-primary btn-lick">Click Here To Extract To Excel</a></p>
                </div>
                <div class="card-body">
                  <div class="table-responsive">
                    <table class="table" id="report_data">
                      <thead class=" text-primary">
                        <th>
                          No.
                        </th>						            
                        <th>
                         Product Name
                        </th>
                        <th>
                         Product Descrition
                        </th>
                         <th>
                         Num Setup
                        </th>
                        <th>
                         Date
                        </th>
                        <th>
                          Controls
                        </th>
                        <th>
                        <a href="product_add.php" rel="tooltip" title="Add New" class="btn btn-primary btn-link btn-sm">
                            <i class="material-icons">save</i>
                            </a>
                        </th>
                      </thead>
                     <tbody>
                     
    <?php
$no = 0;
while ($test_user = $result->fetch_assoc()) {
    $product_name = htmlspecialchars($test_user['product_name'], ENT_QUOTES, 'UTF-8');
    $product_description = htmlspecialchars($test_user['product_description'], ENT_QUOTES, 'UTF-8');

    $product_index = htmlspecialchars($test_user['product_index'], ENT_QUOTES, 'UTF-8');
    
    $product_policy_num = htmlspecialchars($test_user['product_num_code'].'/'.$test_user['product_num_date'].'/'.$test_user['product_num_gen'], ENT_QUOTES, 'UTF-8'); 
    //date
$product_inputdate = '';
if (!empty($test_user['product_inputdate'])) {
    $date = new DateTime($test_user['product_inputdate']);
    $product_inputdate = $date->format('d-m-Y');
}


    $no++;


    // Encrypt the data
$product_indexn = encrypt($product_index);
//$branchindexn = urlencode($branchindexn);


    // Output the table row with sanitized data
    echo '<tr>
              <td>' . $no . '</td>
              <td>' . $product_name . '</td>
              <td>' . $product_description . '</td>
              <td>' . $product_policy_num . '</td>
              <td>' . $product_inputdate . '</td>
            <td class="td-actions text-center">
                  <a href="product_edit.php?sr='.$sr.'&id=' . urlencode($product_indexn) . '" rel="tooltip" title="Edit Task" class="btn btn-primary btn-link btn-sm">
                      <i class="material-icons">edit</i>
                  </a>
                  <a href="product_delete_approval.php?sr='.$sr.'&id=' . urlencode($product_indexn) . '" rel="tooltip" title="Remove" class="btn btn-danger btn-link btn-sm">
                      <i class="material-icons">close</i>
                  </a>
              </td>
          </tr>';
}
?>                     
                          </td>                              
                        </tr>
                      </tbody>
                    </table>
                    </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<script>
    function html_table_to_excel(type) {
        var data = document.getElementById('report_data');
        var file = XLSX.utils.table_to_book(data, { sheet: "sheet1" });
        XLSX.writeFile(file, 'file.' + type);
    }

    const export_button = document.getElementById('export_button');
    export_button.addEventListener('click', () => {
        html_table_to_excel('xlsx');
    });
</script>
</body>
</html>