<?php

// Show all errors during development (turn off in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

include("database.php");
include('log_functions.php');	
session_start();

// ✅ Check user session for authentication
if (!isset($_SESSION['userindex'])) {
    die("Unauthorized access.");
}

// ✅ Sanitize and validate inputs
$product_parameters_product_index = filter_input(INPUT_POST, 'product_parameters_product_index', FILTER_SANITIZE_STRING);
$premium_main_life = filter_input(INPUT_POST, 'premium_main_life', FILTER_SANITIZE_STRING);
$premium_main_plus_one_parent = filter_input(INPUT_POST, 'premium_main_plus_one_parent', FILTER_SANITIZE_STRING);
$premium_main_plus_two_parents = filter_input(INPUT_POST, 'premium_main_plus_two_parents', FILTER_SANITIZE_STRING);
$sum_assured = filter_input(INPUT_POST, 'sum_assured', FILTER_SANITIZE_STRING);
$is_active = filter_input(INPUT_POST, 'is_active', FILTER_SANITIZE_STRING);
$userindex = $_SESSION['userindex']; // From session
$id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_STRING);

// ✅ Validate ID before proceeding
if (empty($id)) {
    die("Invalid request. ID missing.");
}

// ✅ Prepare UPDATE statement (fixed duplicate column)
$stmt = $con->prepare("
    UPDATE cover_levels 
    SET 
        product_index = ?,
        sum_assured = ?,
        premium_main_life = ?,
        premium_main_plus_one_parent = ?,
        premium_main_plus_two_parents = ?,
        is_active = ?,
        userindex = ?,
        inputdate = ?
    WHERE cover_level_id = ?
");

if (!$stmt) {
    die("Prepare failed: " . $con->error);
}

$inputdate = date("Y-m-d H:i:s"); // Format current date

// 9 placeholders → 9 type chars
$stmt->bind_param(
    "sssssssss",   // 9 placeholders: all treated as strings
    $product_parameters_product_index,   // product_index
    $sum_assured,
    $premium_main_life,
    $premium_main_plus_one_parent,
    $premium_main_plus_two_parents,
    $is_active,
    $userindex,
    $inputdate,
    $id           // cover_level_id (WHERE)
);

// ✅ Execute the statement and handle errors securely
if ($stmt->execute()) {
    $page_path = 'parameters_edit.php';
    $reasons   = 'Record updated successfully';
    $data_inf = 'N/A';
    log_failed_login($con, $userindex, $page_path, $reasons ,$data_inf); // (function name is a bit funny but ok)

    header("Location: parameters_report.php?sr=018!b112&msg=10$000?c");
    exit;
} else {
    error_log("Database error: " . $stmt->error);
    die("An error occurred while processing your request. Please try again later.");
}

$stmt->close();

?>
