<?php
// Start the session
if (session_status() === PHP_SESSION_NONE) {
    session_start();

// Check if the user is logged in (session variable is set)
if (!isset($_SESSION['userindex']) || empty($_SESSION['userindex'])) {
    // If not logged in, destroy the session and redirect to login page with a message
    session_unset();  // Remove all session variables
    session_destroy(); // Destroy the session

    // Redirect to login page with a message code (15)
    header("Location: login.php?msg=15");
    exit;  // Ensure no further code is executed
}

// Optional: Regenerate session ID to prevent session fixation
session_regenerate_id(true);
}

?>
