<?php

//Connect to Database
include("database.php");
require_once('crypto_functions.php');
include("session.php");


$id = htmlspecialchars(
    filter_var(
        mysqli_real_escape_string($con, $_REQUEST['id']),
        FILTER_SANITIZE_STRING
    )
);


// Encrypt the data
$id = decrypt($id);
$subscriber_id = urlencode($id);

//$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Get subscriber ID from URL
//$subscriber_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

//echo $subscriber_id;exit;


// Fetch main subscriber details
$subscriber = [];
$additional_lives = [];
$beneficiaries = [];

if ($subscriber_id > 0) {
    // Get main subscriber details
    $stmt = $con->prepare("SELECT * FROM subscription_main WHERE subscriptions_id = ?");
    $stmt->bind_param("i", $subscriber_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $subscriber = $result->fetch_assoc();
        
        // Get additional life details
        $stmt2 = $con->prepare("SELECT * FROM subscription_additionallife WHERE subscriptions_id = ? ORDER BY subscriptions_id_addtional");
        $stmt2->bind_param("i", $subscriber_id);
        $stmt2->execute();
        $result2 = $stmt2->get_result();
        
        while ($row = $result2->fetch_assoc()) {
            $additional_lives[] = $row;
        }
        $stmt2->close();
        
        // Get beneficiaries details from subscription_beneficiaries table
        $stmt3 = $con->prepare("SELECT * FROM subscription_beneficiaries WHERE subscriptions_id = ? ORDER BY subscription_beneficiary_id");
        $stmt3->bind_param("i", $subscriber_id);
        $stmt3->execute();
        $result3 = $stmt3->get_result();
        
        while ($row = $result3->fetch_assoc()) {
            $beneficiaries[] = $row;
        }
        $stmt3->close();
    }
    $stmt->close();
}

// Close connection
$con->close();
?>
<?php include 'main_menu.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Subscriber Details</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

    <style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}

.blue-text {
    color: blue;
}
</style>

    <style>
        :root {
            --primary-color: #6ec1e4;
            --secondary-color: #0a2cea;
            --success-color: #28a745;
            --danger-color: #dc3545;
            --light-bg: #f8f9fa;
            --border-radius: 10px;
            --box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        
        body {
            background-color: #f5f7fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .card-header-primary {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%) !important;
            color: white !important;
            border-radius: var(--border-radius) var(--border-radius) 0 0 !important;
        }
        
        .card-title {
            color: white !important;
            font-weight: 700 !important;
            text-shadow: 1px 1px 3px rgba(0,0,0,0.2);
            font-size: 1.5rem;
        }
        
        .card-category {
            color: rgba(255,255,255,0.9) !important;
            font-size: 0.95rem;
        }
        
        .info-card {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            margin-bottom: 25px;
            overflow: hidden;
            border: none;
        }
        
        .section-header {
            background: linear-gradient(to right, #f8f9fa, #e9f7fe);
            padding: 15px 20px;
            border-bottom: 2px solid var(--primary-color);
            margin-bottom: 0;
        }
        
        .section-title {
            color: var(--secondary-color);
            font-weight: 600;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .section-title i {
            font-size: 1.2rem;
        }
        
        .info-row {
            padding: 15px 20px;
            border-bottom: 1px solid #eef2f7;
            display: flex;
            align-items: center;
            transition: background-color 0.2s;
        }
        
        .info-row:hover {
            background-color: #fafdff;
        }
        
        .info-row:last-child {
            border-bottom: none;
        }
        
        .label {
            font-weight: 600;
            color: #495057;
            min-width: 200px;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .value {
            color: #212529;
            font-weight: 500;
        }
        
        .badge-status {
            padding: 6px 15px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 0.85rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .badge-success {
            background-color: rgba(40, 167, 69, 0.15);
            color: var(--success-color);
            border: 1px solid rgba(40, 167, 69, 0.3);
        }
        
        .badge-failed {
            background-color: rgba(220, 53, 69, 0.15);
            color: var(--danger-color);
            border: 1px solid rgba(220, 53, 69, 0.3);
        }
        
        .badge-channel {
            background-color: rgba(110, 193, 228, 0.15);
            color: var(--primary-color);
            border: 1px solid rgba(110, 193, 228, 0.3);
            padding: 4px 12px;
            border-radius: 15px;
            font-size: 0.8rem;
        }
        
        .additional-life-card {
            border-left: 4px solid var(--primary-color);
            border-radius: 8px;
            margin-bottom: 15px;
            transition: transform 0.2s;
        }
        
        .additional-life-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
        }
        
        .beneficiary-card {
            border-left: 4px solid #ffc107;
            border-radius: 8px;
            margin-bottom: 15px;
            transition: transform 0.2s;
        }
        
        .beneficiary-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(255, 193, 7, 0.1);
        }
        
        .relationship-badge {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 4px 15px;
            border-radius: 15px;
            font-size: 0.8rem;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .beneficiary-badge {
            background: linear-gradient(135deg, #ffc107, #ff9800);
            color: white;
            padding: 4px 15px;
            border-radius: 15px;
            font-size: 0.8rem;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .back-btn {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            border: none;
            padding: 10px 25px;
            border-radius: 25px;
            font-weight: 600;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
        }
        
        .back-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(110, 193, 228, 0.4);
            color: white;
            text-decoration: none;
        }
        
        .stats-card {
            background: white;
            border-radius: var(--border-radius);
            padding: 20px;
            box-shadow: var(--box-shadow);
            text-align: center;
            margin-bottom: 20px;
        }
        
        .stats-icon {
            font-size: 2rem;
            color: var(--primary-color);
            margin-bottom: 10px;
        }
        
        .stats-number {
            font-size: 1.8rem;
            font-weight: 700;
            color: var(--secondary-color);
            margin-bottom: 5px;
        }
        
        .stats-label {
            color: #6c757d;
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .no-data {
            text-align: center;
            padding: 40px 20px;
            color: #6c757d;
        }
        
        .no-data i {
            font-size: 3rem;
            color: #dee2e6;
            margin-bottom: 15px;
        }
        
        .header-actions {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .subscriber-name {
            color: var(--secondary-color);
            font-weight: 700;
            font-size: 1.8rem;
            margin: 0;
        }
        
        .subscriber-id {
            color: #6c757d;
            font-size: 0.9rem;
        }
        
        .contact-badge {
            background-color: #e3f2fd;
            color: #1976d2;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 0.8rem;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }
        
        .beneficiary-info {
            background: #fff8e1;
            border-radius: 8px;
            padding: 10px;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">            
                        <div class="card-header card-header-primary" style="text-align: center; padding: 20px;">
                            <h4 class="card-title">
                                <i class="fas fa-user-circle"></i> Subscriber Details
                            </h4>
                            <p class="card-category">Complete information about the subscriber, additional lives, and beneficiaries</p>
                        </div>
                        
                        <div class="card-body">
                            <?php if (empty($subscriber)): ?>
                                <div class="no-data">
                                    <i class="fas fa-user-slash"></i>
                                    <h4>Subscriber Not Found</h4>
                                    <p>The subscriber you're looking for doesn't exist or has been removed.</p>
                                    <a href="javascript:history.back()" class="back-btn mt-3">
                                        <i class="fas fa-arrow-left"></i> Go Back
                                    </a>
                                </div>
                            <?php else: ?>
                                <!-- Header Actions -->
                                <div class="header-actions">
                                    <div>
                                        <h1 class="subscriber-name">
                                            <?php echo htmlspecialchars($subscriber['full_name']); ?>
                                        </h1>
                                        <div class="subscriber-id">
                                            ID: <?php echo htmlspecialchars($subscriber['subscriptions_id']); ?>
                                            | Policy: <?php echo htmlspecialchars($subscriber['policy_number'] ?? 'N/A'); ?>
                                        </div>
                                    </div>
                                    <a href="javascript:history.back()" class="back-btn">
                                        <i class="fas fa-arrow-left"></i> Back to List
                                    </a>
                                </div>
                                
                                <!-- Quick Stats -->
                                <div class="row mb-4">
                                    <div class="col-md-3">
                                        <div class="stats-card">
                                            <div class="stats-icon">
                                                <i class="fas fa-phone-alt"></i>
                                            </div>
                                            <div class="stats-number">
                                                <?php echo htmlspecialchars($subscriber['mobile_money_number']); ?>
                                            </div>
                                            <div class="stats-label">Mobile Number</div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="stats-card">
                                            <div class="stats-icon">
                                                <i class="fas fa-file-invoice"></i>
                                            </div>
                                            <div class="stats-number">
                                                <?php echo htmlspecialchars($subscriber['policy_number'] ?? 'N/A'); ?>
                                            </div>
                                            <div class="stats-label">Policy Number</div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="stats-card">
                                            <div class="stats-icon">
                                                <i class="fas fa-users"></i>
                                            </div>
                                            <div class="stats-number">
                                                <?php echo count($additional_lives) + 1; ?>
                                            </div>
                                            <div class="stats-label">Total Lives</div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="stats-card">
                                            <div class="stats-icon">
                                                <i class="fas fa-user-friends"></i>
                                            </div>
                                            <div class="stats-number">
                                                <?php echo count($beneficiaries); ?>
                                            </div>
                                            <div class="stats-label">Beneficiaries</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Subscriber Details Section -->
                                <div class="info-card">
                                    <div class="section-header">
                                        <h3 class="section-title">
                                            <i class="fas fa-user"></i> Subscriber Details
                                        </h3>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="label">
                                            <i class="fas fa-user-tag"></i> Type
                                        </div>
                                        <div class="value">
                                            <span class="badge badge-success badge-status">Self</span>
                                        </div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="label">
                                            <i class="fas fa-user"></i> Full Name
                                        </div>
                                        <div class="value">
                                            <?php echo htmlspecialchars($subscriber['full_name']); ?>
                                        </div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="label">
                                            <i class="fas fa-birthday-cake"></i> Date of Birth
                                        </div>
                                        <div class="value">
                                            <?php echo htmlspecialchars($subscriber['date_of_birth']); ?>
                                        </div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="label">
                                            <i class="fas fa-file-invoice"></i> Ref Number
                                        </div>
                                        <div class="value">
                                            <?php echo htmlspecialchars($subscriber['policy_number']); ?>
                                        </div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="label">
                                            <i class="fas fa-calendar-alt"></i> Input Date
                                        </div>
                                        <div class="value">
                                            <?php echo htmlspecialchars($subscriber['input_date']); ?>
                                        </div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="label">
                                            <i class="fas fa-money-bill-wave"></i> Premium
                                        </div>
                                        <div class="value">
                                            <strong>GHS <?php echo number_format($subscriber['total_premium'], 2); ?></strong>
                                        </div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="label">
                                            <i class="fas fa-sign-in-alt"></i> Onboarding Channel
                                        </div>
                                        <div class="value">
                                            <span class="badge-channel">
                                                <?php echo htmlspecialchars($subscriber['onboarding_channel']); ?>
                                            </span>
                                        </div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="label">
                                            <i class="fas fa-credit-card"></i> Payment Status
                                        </div>
                                        <div class="value">
                                            <span class="badge-status <?php echo $subscriber['payment_status'] == 'Success' ? 'badge-success' : 'badge-failed'; ?>">
                                                <?php echo htmlspecialchars($subscriber['payment_status']); ?>
                                            </span>
                                        </div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="label">
                                            <i class="fas fa-box"></i> Product Name
                                        </div>
                                        <div class="value">
                                            <?php echo htmlspecialchars($subscriber['product_name']); ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Additional Life Details Section (Moved before Beneficiaries) -->
                                <div class="info-card">
                                    <div class="section-header">
                                        <h3 class="section-title">
                                            <i class="fas fa-users"></i> Additional Life Details
                                            <span class="badge badge-primary ml-2" style="background: var(--primary-color);">
                                                <?php echo count($additional_lives); ?> Person(s)
                                            </span>
                                        </h3>
                                    </div>
                                    
                                    <?php if (count($additional_lives) > 0): ?>
                                        <div class="row">
                                            <?php foreach ($additional_lives as $index => $life): ?>
                                                <div class="col-md-6">
                                                    <div class="additional-life-card">
                                                        <div class="card-body">
                                                            <div class="d-flex justify-content-between align-items-start mb-3">
                                                                <h5 class="mb-0" style="color: var(--secondary-color);">
                                                                    <?php echo htmlspecialchars($life['full_name']); ?>
                                                                </h5>
                                                                <span class="relationship-badge">
                                                                    <?php echo htmlspecialchars($life['relationship']); ?>
                                                                </span>
                                                            </div>
                                                            
                                                            <div class="row">
                                                                <div class="col-6">
                                                                    <div class="mb-2">
                                                                        <small class="text-muted">
                                                                            <i class="fas fa-mobile-alt"></i> Mobile Number
                                                                        </small>
                                                                        <div class="font-weight-medium">
                                                                            <?php echo htmlspecialchars($life['mobile_money_number']); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-6">
                                                                    <div class="mb-2">
                                                                        <small class="text-muted">
                                                                            <i class="fas fa-venus-mars"></i> Gender
                                                                        </small>
                                                                        <div class="font-weight-medium">
                                                                            <?php echo htmlspecialchars($life['gender']); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="row">
                                                                <div class="col-6">
                                                                    <div class="mb-2">
                                                                        <small class="text-muted">
                                                                            <i class="fas fa-birthday-cake"></i> Date of Birth
                                                                        </small>
                                                                        <div class="font-weight-medium">
                                                                            <?php echo htmlspecialchars($life['date_of_birth']); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-6">
                                                                    <div class="mb-2">
                                                                        <small class="text-muted">
                                                                            <i class="fas fa-hashtag"></i> Additional Life ID
                                                                        </small>
                                                                        <div class="font-weight-medium">
                                                                            #<?php echo htmlspecialchars($life['subscriptions_id_addtional']); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="mt-2">
                                                                <small class="text-muted">
                                                                    <i class="fas fa-calendar-alt"></i> Date Added
                                                                </small>
                                                                <div class="font-weight-medium">
                                                                    <?php echo htmlspecialchars($life['date']); ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php else: ?>
                                        <div class="text-center py-4">
                                            <i class="fas fa-users-slash" style="font-size: 3rem; color: #dee2e6;"></i>
                                            <h5 class="mt-3 text-muted">No Additional Lives Found</h5>
                                            <p class="text-muted">This subscriber doesn't have any additional life insured.</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                
                                <!-- Beneficiaries Section (Moved after Additional Life Details) -->
                                <div class="info-card">
                                    <div class="section-header">
                                        <h3 class="section-title">
                                            <i class="fas fa-user-friends"></i> Beneficiaries
                                            <span class="badge badge-warning ml-2" style="background: #ffc107; color: #000;">
                                                <?php echo count($beneficiaries); ?> Person(s)
                                            </span>
                                        </h3>
                                    </div>
                                    
                                    <?php if (count($beneficiaries) > 0): ?>
                                        <div class="row">
                                            <?php foreach ($beneficiaries as $index => $beneficiary): ?>
                                                <div class="col-md-6">
                                                    <div class="beneficiary-card">
                                                        <div class="card-body">
                                                            <div class="d-flex justify-content-between align-items-start mb-3">
                                                                <h5 class="mb-0" style="color: #ff9800;">
                                                                    <?php echo htmlspecialchars($beneficiary['full_name']); ?>
                                                                </h5>
                                                                <span class="beneficiary-badge">
                                                                    <?php echo htmlspecialchars($beneficiary['relationship']); ?>
                                                                </span>
                                                            </div>
                                                            
                                                            <div class="row">
                                                                <div class="col-6">
                                                                    <div class="mb-2">
                                                                        <small class="text-muted">
                                                                            <i class="fas fa-mobile-alt"></i> Mobile Number
                                                                        </small>
                                                                        <div class="font-weight-medium">
                                                                            <?php echo htmlspecialchars($beneficiary['mobile_money_number']); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-6">
                                                                    <div class="mb-2">
                                                                        <small class="text-muted">
                                                                            <i class="fas fa-hashtag"></i> Beneficiary ID
                                                                        </small>
                                                                        <div class="font-weight-medium">
                                                                            #<?php echo htmlspecialchars($beneficiary['subscription_beneficiary_id']); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="mt-2">
                                                                <small class="text-muted">
                                                                    <i class="fas fa-calendar-alt"></i> Date Added
                                                                </small>
                                                                <div class="font-weight-medium">
                                                                    <?php echo htmlspecialchars($beneficiary['created_at']); ?>
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="mt-3">
                                                                <div class="contact-badge">
                                                                    <i class="fas fa-phone"></i>
                                                                    <?php echo htmlspecialchars($beneficiary['mobile_money_number']); ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php else: ?>
                                        <div class="text-center py-4">
                                            <i class="fas fa-user-friends-slash" style="font-size: 3rem; color: #dee2e6;"></i>
                                            <h5 class="mt-3 text-muted">No Beneficiaries Found</h5>
                                            <p class="text-muted">This subscriber doesn't have any registered beneficiaries.</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                
                                <!-- Summary Section -->
                                <div class="info-card">
                                    <div class="section-header">
                                        <h3 class="section-title">
                                            <i class="fas fa-chart-pie"></i> Policy Summary
                                        </h3>
                                    </div>
                                    <div class="p-4">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="text-center p-3">
                                                    <div class="display-4 text-primary font-weight-bold">
                                                        <?php echo htmlspecialchars($subscriber['policy_number'] ?? 'N/A'); ?>
                                                    </div>
                                                    <div class="text-muted">Policy Number</div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="text-center p-3">
                                                    <div class="display-4 text-success font-weight-bold">
                                                        GHS <?php echo number_format($subscriber['total_premium'], 2); ?>
                                                    </div>
                                                    <div class="text-muted">Total Premium</div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="text-center p-3">
                                                    <div class="display-4 text-warning font-weight-bold">
                                                        <?php echo count($additional_lives); ?>
                                                    </div>
                                                    <div class="text-muted">Additional Lives</div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="text-center p-3">
                                                    <div class="display-4 text-info font-weight-bold">
                                                        <?php echo count($beneficiaries); ?>
                                                    </div>
                                                    <div class="text-muted">Beneficiaries</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- REMOVED: Action Buttons Section -->
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    
    <script>
        // REMOVED: Print functionality
        // REMOVED: Export functionality
        // REMOVED: Button event listeners
        
        // Format dates on page load
        document.addEventListener('DOMContentLoaded', function() {
            // You can add date formatting here if needed
        });
    </script>
</body>
</html>