<?php
//Connect to Database
include("database.php");
require_once('crypto_functions.php');
include('log_functions.php');	
include("session.php");

// Get user index (assume numeric)
$userindex = isset($_SESSION['userindex']) ? (int)$_SESSION['userindex'] : 0;


$id = htmlspecialchars(
    filter_var(
        mysqli_real_escape_string($con, $_REQUEST['id']),
        FILTER_SANITIZE_STRING
    )
);


// Encrypt the data
$id = decrypt($id);
$subscriber_id = urlencode($id);


//Check if the same mobile number exist in the subscription_main and 



//echo "it move on";exit;

// ==============================
// READ & PREPARE VALUES
// ==============================
$que_status       = 1;                               // e.g. approved/processed
$input_date       = date("Y-m-d H:i:s");             // now
$que_updated_date = date("Y-m-d H:i:s");             // now

// ==============================
// PREPARE SECURE UPDATE QUERY
// ==============================
$sql = "
    UPDATE subscription_main SET        
        que_status      = ?,
        que_userindex   = ?,
        que_updated_date= ?
    WHERE subscriptions_id = ?
";

$stmt = $con->prepare($sql);

if (!$stmt) {
    die("Prepare failed: " . $con->error);
}

// Types: i = int, s = string
// que_status (int), que_userindex (int), input_date (string), que_updated_date (string), subscriptions_id (int)
$stmt->bind_param(
    "iisi",
    $que_status,
    $userindex,
    $que_updated_date,
    $subscriber_id
);


// Call the log_failed_login function
$page_path = 'subscription_add.php';
$reasons = 'Add Successfully';
$data_inf = "Queue Status: $que_status, "
         . "User: $userindex, "
         . "Updated Date: $que_updated_date";
log_failed_login($con, $userindex, $page_path, $reasons ,$data_inf);


// ==============================
// EXECUTE & SHOW POPUP
// ==============================
if ($stmt->execute()) {
    // JavaScript popup + redirect (change location as needed)
    echo "<script>
            alert('Added successfully.');
            window.location.href = 'subscription.php';
          </script>";
} else {
    echo "<script>
            alert('failed: " . addslashes($stmt->error) . "');
            window.history.back();
          </script>";
}

$stmt->close();
$con->close();
?>
