<?php

//Connect to Database
include("database.php");
//require_once('crypto_functions.php');
include("session.php");


$search_results = [];
$additional_results = [];
$search_performed = false;

// Get distinct values for dropdowns
$payment_statuses = [];
$channels = [];
$products = [];
$relationships = [];
$genders = [];

$status_query = "SELECT DISTINCT payment_status FROM subscription_main WHERE payment_status IS NOT NULL ORDER BY payment_status";
$status_result = $con->query($status_query);
while($row = $status_result->fetch_assoc()) {
    $payment_statuses[] = $row['payment_status'];
}

$channel_query = "SELECT DISTINCT onboarding_channel FROM subscription_main WHERE onboarding_channel IS NOT NULL ORDER BY onboarding_channel";
$channel_result = $con->query($channel_query);
while($row = $channel_result->fetch_assoc()) {
    $channels[] = $row['onboarding_channel'];
}

$product_query = "SELECT DISTINCT product_name FROM subscription_main WHERE product_name IS NOT NULL ORDER BY product_name";
$product_result = $con->query($product_query);
while($row = $product_result->fetch_assoc()) {
    $products[] = $row['product_name'];
}

$rel_query = "SELECT DISTINCT relationship FROM subscription_additionallife WHERE relationship IS NOT NULL ORDER BY relationship";
$rel_result = $con->query($rel_query);
while($row = $rel_result->fetch_assoc()) {
    $relationships[] = $row['relationship'];
}

$gender_query = "SELECT DISTINCT gender FROM subscription_additionallife WHERE gender IS NOT NULL ORDER BY gender";
$gender_result = $con->query($gender_query);
while($row = $gender_result->fetch_assoc()) {
    $genders[] = $row['gender'];
}

// Handle search form submission
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['search'])) {
    $search_performed = true;
    
    // Build WHERE clause for main table
    $where_clauses = [];
    $params = [];
    $types = "";
    
    if (!empty($_POST['mobile_money_number'])) {
        $where_clauses[] = "m.mobile_money_number LIKE ?";
        $params[] = "%" . $_POST['mobile_money_number'] . "%";
        $types .= "s";
    }
    
    if (!empty($_POST['full_name'])) {
        $where_clauses[] = "m.full_name LIKE ?";
        $params[] = "%" . $_POST['full_name'] . "%";
        $types .= "s";
    }
    
    if (!empty($_POST['policy_number'])) {
        $where_clauses[] = "m.policy_number LIKE ?";
        $params[] = "%" . $_POST['policy_number'] . "%";
        $types .= "s";
    }
    
    if (!empty($_POST['payment_status']) && $_POST['payment_status'] != 'all') {
        $where_clauses[] = "m.payment_status = ?";
        $params[] = $_POST['payment_status'];
        $types .= "s";
    }
    
    if (!empty($_POST['onboarding_channel']) && $_POST['onboarding_channel'] != 'all') {
        $where_clauses[] = "m.onboarding_channel = ?";
        $params[] = $_POST['onboarding_channel'];
        $types .= "s";
    }
    
    if (!empty($_POST['product_name']) && $_POST['product_name'] != 'all') {
        $where_clauses[] = "m.product_name = ?";
        $params[] = $_POST['product_name'];
        $types .= "s";
    }
    
    if (!empty($_POST['date_from'])) {
        $where_clauses[] = "DATE(m.input_date) >= ?";
        $params[] = $_POST['date_from'];
        $types .= "s";
    }
    
    if (!empty($_POST['date_to'])) {
        $where_clauses[] = "DATE(m.input_date) <= ?";
        $params[] = $_POST['date_to'];
        $types .= "s";
    }
    
    // Prepare and execute main query
    $sql = "SELECT m.* FROM subscription_main m";
    
    if (!empty($where_clauses)) {
        $sql .= " WHERE " . implode(" AND ", $where_clauses);
    }
    
    $sql .= " ORDER BY m.subscriptions_id DESC";
    
    $stmt = $con->prepare($sql);
    
    if (!empty($params)) {
        $stmt->bind_param($types, ...$params);
    }
    
    $stmt->execute();
    $main_result = $stmt->get_result();
    
    if ($main_result->num_rows > 0) {
        while($row = $main_result->fetch_assoc()) {
            $search_results[] = $row;
            
            // Get additional life records for this subscription
            $add_id = $row['subscriptions_id'];
            $add_sql = "SELECT * FROM subscription_additionallife WHERE subscriptions_id = ?";
            $add_stmt = $con->prepare($add_sql);
            $add_stmt->bind_param("i", $add_id);
            $add_stmt->execute();
            $add_result = $add_stmt->get_result();
            
            $additional_results[$add_id] = [];
            while($add_row = $add_result->fetch_assoc()) {
                $additional_results[$add_id][] = $add_row;
            }
            $add_stmt->close();
        }
    }
    $stmt->close();
}
?>
<?php include 'main_menu.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Advanced Search - Insurance Subscriptions</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

    <style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}


</style>

    <style>
        .card-header-primary {
            background: linear-gradient(135deg, #6ec1e4 0%, #0a2cea 100%) !important;
            color: white !important;
        }
        .card-title {
            color: white !important;
            font-weight: bold !important;
            text-shadow: 1px 1px 3px rgba(0,0,0,0.3);
        }
        .search-btn {
            background: linear-gradient(135deg, #6ec1e4 0%, #0a2cea 100%);
            color: white;
            border: none;
            padding: 10px 30px;
            font-weight: bold;
        }
        .search-btn:hover {
            background: linear-gradient(135deg, #5ab0d3 0%, #0925c7 100%);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            transition: all 0.3s ease;
        }
        .reset-btn {
            background: #6c757d;
            color: white;
            border: none;
            padding: 10px 30px;
            font-weight: bold;
        }
        .reset-btn:hover {
            background: #5a6268;
            color: white;
        }
        .filter-section {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            border-left: 5px solid #6ec1e4;
        }
        .filter-title {
            color: #0a2cea;
            font-weight: bold;
            margin-bottom: 15px;
            border-bottom: 2px solid #e9ecef;
            padding-bottom: 8px;
        }
        .form-group label {
            font-weight: 600;
            color: #495057;
        }
        .table-container {
            margin-top: 30px;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .results-count {
            background: #0a2cea;
            color: white;
            padding: 10px 20px;
            border-radius: 5px;
            margin-bottom: 20px;
            display: inline-block;
            font-weight: bold;
        }
        .badge-success {
            background-color: #28a745;
            color: white;
            padding: 5px 10px;
            border-radius: 20px;
        }
        .badge-danger {
            background-color: #dc3545;
            color: white;
            padding: 5px 10px;
            border-radius: 20px;
        }
        .badge-info {
            background-color: #17a2b8;
            color: white;
            padding: 5px 10px;
            border-radius: 20px;
        }
        .accordion-button {
            background-color: #f8f9fa;
            color: #0a2cea;
            font-weight: bold;
        }
        .accordion-button:not(.collapsed) {
            background-color: #e9f7fe;
            color: #0a2cea;
        }
        .additional-life-table {
            background-color: #f8f9fa;
            border-radius: 5px;
        }
        .no-results {
            text-align: center;
            padding: 40px;
            color: #6c757d;
            background: #f8f9fa;
            border-radius: 10px;
            border: 2px dashed #dee2e6;
        }
        .no-results i {
            font-size: 48px;
            color: #6ec1e4;
            margin-bottom: 15px;
        }
        .stats-card {
            background: white;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            border-left: 4px solid #6ec1e4;
        }
        .stats-number {
            font-size: 24px;
            font-weight: bold;
            color: #0a2cea;
        }
        .stats-label {
            color: #6c757d;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header card-header-primary" style="text-align: center; padding: 20px;">
                            <h4 class="card-title">
                                <i class="fas fa-search"></i> Advanced Search
                            </h4>
                            <p class="card-category" style="color: rgba(255,255,255,0.9);">Search insurance subscriptions with multiple filters</p>
                        </div>
                        <div class="card-body">
                            <!-- Search Form -->
                            <form method="POST" action="">
                                <div class="filter-section">
                                    <h5 class="filter-title">
                                        <i class="fas fa-filter"></i> Basic Filters
                                    </h5>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="mobile_money_number">
                                                    <i class="fas fa-mobile-alt"></i> Mobile Money Number
                                                </label>
                                                <input type="text" class="form-control" id="mobile_money_number" name="mobile_money_number" 
                                                       value="<?php echo isset($_POST['mobile_money_number']) ? htmlspecialchars($_POST['mobile_money_number']) : ''; ?>"
                                                       placeholder="Enter mobile number">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="full_name">
                                                    <i class="fas fa-user"></i> Full Name
                                                </label>
                                                <input type="text" class="form-control" id="full_name" name="full_name" 
                                                       value="<?php echo isset($_POST['full_name']) ? htmlspecialchars($_POST['full_name']) : ''; ?>"
                                                       placeholder="Enter full name">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="policy_number">
                                                    <i class="fas fa-file-invoice"></i> Policy Number
                                                </label>
                                                <input type="text" class="form-control" id="policy_number" name="policy_number" 
                                                       value="<?php echo isset($_POST['policy_number']) ? htmlspecialchars($_POST['policy_number']) : ''; ?>"
                                                       placeholder="Enter policy number">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="filter-section">
                                    <h5 class="filter-title">
                                        <i class="fas fa-cog"></i> Advanced Filters
                                    </h5>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="payment_status">
                                                    <i class="fas fa-credit-card"></i> Payment Status
                                                </label>
                                                <select class="form-control" id="payment_status" name="payment_status">
                                                    <option value="all">All Status</option>
                                                    <?php foreach($payment_statuses as $status): ?>
                                                        <option value="<?php echo $status; ?>" 
                                                            <?php echo (isset($_POST['payment_status']) && $_POST['payment_status'] == $status) ? 'selected' : ''; ?>>
                                                            <?php echo $status; ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="onboarding_channel">
                                                    <i class="fas fa-sign-in-alt"></i> Onboarding Channel
                                                </label>
                                                <select class="form-control" id="onboarding_channel" name="onboarding_channel">
                                                    <option value="all">All Channels</option>
                                                    <?php foreach($channels as $channel): ?>
                                                        <option value="<?php echo $channel; ?>" 
                                                            <?php echo (isset($_POST['onboarding_channel']) && $_POST['onboarding_channel'] == $channel) ? 'selected' : ''; ?>>
                                                            <?php echo $channel; ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="product_name">
                                                    <i class="fas fa-box"></i> Product Name
                                                </label>
                                                <select class="form-control" id="product_name" name="product_name">
                                                    <option value="all">All Products</option>
                                                    <?php foreach($products as $product): ?>
                                                        <option value="<?php echo $product; ?>" 
                                                            <?php echo (isset($_POST['product_name']) && $_POST['product_name'] == $product) ? 'selected' : ''; ?>>
                                                            <?php echo $product; ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="filter-section">
                                    <h5 class="filter-title">
                                        <i class="fas fa-calendar-alt"></i> Date Range
                                    </h5>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="date_from">
                                                    <i class="fas fa-calendar-plus"></i> Date From
                                                </label>
                                                <input type="date" class="form-control" id="date_from" name="date_from" 
                                                       value="<?php echo isset($_POST['date_from']) ? htmlspecialchars($_POST['date_from']) : ''; ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="date_to">
                                                    <i class="fas fa-calendar-minus"></i> Date To
                                                </label>
                                                <input type="date" class="form-control" id="date_to" name="date_to" 
                                                       value="<?php echo isset($_POST['date_to']) ? htmlspecialchars($_POST['date_to']) : ''; ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-12 text-center">
                                        <button type="submit" name="search" class="btn search-btn mr-3">
                                            <i class="fas fa-search"></i> Search
                                        </button>
                                        <button type="button" onclick="resetForm()" class="btn reset-btn">
                                            <i class="fas fa-redo"></i> Reset
                                        </button>
                                    </div>
                                </div>
                            </form>
                            
                            <!-- Search Results -->
                            <?php if ($search_performed): ?>
                                <div class="table-container">
                                    <?php if (count($search_results) > 0): ?>
                                        <!-- Statistics -->
                                        <div class="row mt-4">
                                            <div class="col-md-3">
                                                <div class="stats-card">
                                                    <div class="stats-number"><?php echo count($search_results); ?></div>
                                                    <div class="stats-label">Total Records Found</div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <?php 
                                                $success_count = array_filter($search_results, function($item) {
                                                    return $item['payment_status'] == 'Success';
                                                });
                                                ?>
                                                <div class="stats-card">
                                                    <div class="stats-number" style="color: #28a745;"><?php echo count($success_count); ?></div>
                                                    <div class="stats-label">Successful Payments</div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <?php 
                                                $failed_count = array_filter($search_results, function($item) {
                                                    return $item['payment_status'] == 'Failed';
                                                });
                                                ?>
                                                <div class="stats-card">
                                                    <div class="stats-number" style="color: #dc3545;"><?php echo count($failed_count); ?></div>
                                                    <div class="stats-label">Failed Payments</div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <?php 
                                                $total_premium = array_sum(array_column($search_results, 'premium'));
                                                ?>
                                                <div class="stats-card">
                                                    <div class="stats-number" style="color: #ffc107;">GHS <?php echo number_format($total_premium, 2); ?></div>
                                                    <div class="stats-label">Total Premium</div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Results Table -->
                                        <div class="accordion" id="resultsAccordion">
                                            <?php foreach ($search_results as $index => $row): ?>
                                                <div class="card mb-2">
                                                    <div class="card-header" id="heading<?php echo $index; ?>">
                                                        <h5 class="mb-0">
                                                            <button class="btn btn-link" type="button" data-toggle="collapse" 
                                                                    data-target="#collapse<?php echo $index; ?>" aria-expanded="false" 
                                                                    aria-controls="collapse<?php echo $index; ?>">
                                                                <i class="fas fa-chevron-down"></i>
                                                                <?php echo htmlspecialchars($row['full_name']); ?> 
                                                                - <?php echo htmlspecialchars($row['mobile_money_number']); ?>
                                                                <span class="badge <?php echo $row['payment_status'] == 'Success' ? 'badge-success' : 'badge-danger'; ?> ml-2">
                                                                    <?php echo $row['payment_status']; ?>
                                                                </span>
                                                                <span class="badge badge-info ml-2">
                                                                    <?php echo $row['onboarding_channel']; ?>
                                                                </span>
                                                            </button>
                                                        </h5>
                                                    </div>
                                                    
                                                    <div id="collapse<?php echo $index; ?>" class="collapse" aria-labelledby="heading<?php echo $index; ?>" data-parent="#resultsAccordion">
                                                        <div class="card-body">
                                                            <!-- Main Subscription Details -->
                                                            <h6>Main Subscription Details</h6>
                                                            <table class="table table-sm table-bordered">
                                                                <tr>
                                                                    <th>Policy Number:</th>
                                                                    <td><?php echo htmlspecialchars($row['policy_number']); ?></td>
                                                                    <th>Product Name:</th>
                                                                    <td><?php echo htmlspecialchars($row['product_name']); ?></td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Date of Birth:</th>
                                                                    <td><?php echo htmlspecialchars($row['date_of_birth']); ?></td>
                                                                    <th>Premium:</th>
                                                                    <td>GHS <?php echo htmlspecialchars($row['premium']); ?></td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Input Date:</th>
                                                                    <td colspan="3"><?php echo htmlspecialchars($row['input_date']); ?></td>
                                                                </tr>
                                                            </table>
                                                            
                                                            <!-- Additional Life Details -->
                                                            <?php if (isset($additional_results[$row['subscriptions_id']]) && count($additional_results[$row['subscriptions_id']]) > 0): ?>
                                                                <h6 class="mt-4">Additional Life Insured</h6>
                                                                <div class="table-responsive">
                                                                    <table class="table table-sm additional-life-table">
                                                                        <thead>
                                                                            <tr>
                                                                                <th>Name</th>
                                                                                <th>Date of Birth</th>
                                                                                <th>Gender</th>
                                                                                <th>Relationship</th>                                                                             
                                                                                <th>Date Added</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <?php foreach ($additional_results[$row['subscriptions_id']] as $add): ?>
                                                                            <tr>
                                                                                <td><?php echo htmlspecialchars($add['full_name']); ?></td>
                                                                                <td><?php echo htmlspecialchars($add['date_of_birth']); ?></td>
                                                                                <td><?php echo htmlspecialchars($add['gender']); ?></td>
                                                                                <td><?php echo htmlspecialchars($add['relationship']); ?></td>                                                                                
                                                                                <td><?php echo htmlspecialchars($add['date']); ?></td>
                                                                            </tr>
                                                                            <?php endforeach; ?>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php else: ?>
                                        <div class="no-results mt-4">
                                            <i class="fas fa-search-minus"></i>
                                            <h4>No Records Found</h4>
                                            <p>Try adjusting your search filters to find what you're looking for.</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    
    <script>
        function resetForm() {
            document.querySelector('form').reset();
        }
        
        // Set default dates
        document.addEventListener('DOMContentLoaded', function() {
            const today = new Date().toISOString().split('T')[0];
            const lastMonth = new Date();
            lastMonth.setMonth(lastMonth.getMonth() - 1);
            const lastMonthStr = lastMonth.toISOString().split('T')[0];
            
            if (!document.getElementById('date_from').value) {
                document.getElementById('date_from').value = lastMonthStr;
            }
            if (!document.getElementById('date_to').value) {
                document.getElementById('date_to').value = today;
            }
        });
    </script>
</body>
</html>

<?php
// Close database connection
$con->close();
?>