<?php
// Calling database connection
include("database.php");
include('log_functions.php');	
include('session.php');

// Sanitize the input using prepared statements to prevent SQL injection
$userindex 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_SESSION['userindex']),FILTER_SANITIZE_STRING));
$id 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['idcode']),FILTER_SANITIZE_STRING));


// Prepare the DELETE statement
$query = "DELETE FROM users WHERE userindex = ?";
$stmt = $con->prepare($query);

if (!$stmt) {
    die("Error preparing statement: " . $con->error);
}

// Bind the parameter to the prepared statement
$stmt->bind_param('s', $id);

// Execute the statement and check for errors
if (!$stmt->execute()) {
    die("Error executing query: " . $stmt->error);
}

// Close the statement
$stmt->close();

// Call the log_failed_login function
$page_path = 'users_delete.php';
$reasons = 'Deleted Successfully';
$data_inf = 'N/A';
log_failed_login($con, $userindex, $page_path, $reasons , $data_inf);

// Redirect to the report page
header("Location: user_report.php?sr=716!b108&msg=10$230?c");
exit;
?>
