<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json; charset=utf-8");

include("database.php"); // must create $con (mysqli)
date_default_timezone_set("Africa/Accra");

$path = $_SERVER['REQUEST_URI'] ?? 'product.php';

/* =========================
   LOG FUNCTION
   Table: users_logs(userindex, caption, logs_date, path, data_inf)
   - userindex: pass mobile_money_number OR userindex; if none, "UNKNOWN"
========================= */
function log_activity($con, $userindex, $caption, $path, $data_inf) {
    if (!isset($con) || !$con) return;

    $sql = "INSERT INTO users_logs (userindex, caption, logs_date, path, data_inf)
            VALUES (?, ?, NOW(), ?, ?)";

    if ($stmt = mysqli_prepare($con, $sql)) {
        $u = (string)$userindex;
        $c = (string)$caption;
        $p = (string)$path;
        $d = (string)$data_inf;

        mysqli_stmt_bind_param($stmt, "ssss", $u, $c, $p, $d);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }
}

function out($con, $userindex, $path, $ok, $extra = [], $caption = null) {
    if ($caption !== null) {
        log_activity($con, $userindex, $caption, $path, json_encode($extra));
    }
    echo json_encode(array_merge(["ok" => (bool)$ok], $extra));
    exit;
}

// ---------- METHOD CHECK ----------
if ($_SERVER["REQUEST_METHOD"] !== "GET" && $_SERVER["REQUEST_METHOD"] !== "POST") {
    // can't know userindex here reliably
    log_activity($con, "UNKNOWN", "INVALID REQUEST METHOD", $path, json_encode([
        "method" => $_SERVER["REQUEST_METHOD"] ?? ""
    ]));
    echo json_encode(["ok" => false]);
    exit;
}

if (!isset($con) || !$con) {
    echo json_encode(["ok" => false, "error" => "DB connection failed"]);
    exit;
}

/*
  Optional identifier for logging.
  - You can pass ?userindex=233244229547 or ?mobile_money_number=233...
  - Or via POST/JSON.
*/
$raw  = file_get_contents("php://input");
$data = json_decode($raw, true);
$isJson = is_array($data);

$userindex = trim(
    $isJson
        ? ($data["userindex"] ?? ($data["mobile_money_number"] ?? ""))
        : ($_REQUEST["userindex"] ?? ($_REQUEST["mobile_money_number"] ?? ""))
);
if ($userindex === "") $userindex = "UNKNOWN";

log_activity($con, $userindex, "REQUEST RECEIVED", $path, json_encode([
    "method" => $_SERVER["REQUEST_METHOD"] ?? "",
    "query" => $_GET ?? []
]));

// ---------- SELECT ALL PRODUCTS ----------
$sql = "SELECT product_index, product_name FROM product ORDER BY product_name ASC";

$stmt = mysqli_prepare($con, $sql);
if (!$stmt) {
    out($con, $userindex, $path, false, ["error" => "Prepare failed", "details" => mysqli_error($con)], "DB PREPARE FAILED");
}

if (!mysqli_stmt_execute($stmt)) {
    $err = mysqli_stmt_error($stmt);
    mysqli_stmt_close($stmt);
    out($con, $userindex, $path, false, ["error" => "Execute failed", "details" => $err], "DB EXECUTE FAILED");
}

$res = mysqli_stmt_get_result($stmt);
mysqli_stmt_close($stmt);

$products = [];
if ($res) {
    while ($row = mysqli_fetch_assoc($res)) {
        $products[] = [
            "product_index" => (int)$row["product_index"],
            "product_name"  => (string)$row["product_name"]
        ];
    }
}

$response = [
    "count" => count($products),
    "products" => $products
];

log_activity($con, $userindex, "PRODUCTS FETCH SUCCESS", $path, json_encode([
    "count" => $response["count"]
]));

// ---------- FINAL RESPONSE ----------
echo json_encode(array_merge(["ok" => true], $response));
?>