<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json; charset=utf-8");

include("database.php"); // must create $con (mysqli)
date_default_timezone_set("Africa/Accra");

$path = $_SERVER['REQUEST_URI'] ?? 'scriptD_cancel_mandate.php';

/* =========================
   LOG FUNCTION
   Table: users_logs(userindex, caption, logs_date, path, data_inf)
   - userindex: mobil_no (customer identifier)
========================= */
function log_activity($con, $userindex, $caption, $path, $data_inf) {
    if (!isset($con) || !$con) return;

    $sql = "INSERT INTO users_logs (userindex, caption, logs_date, path, data_inf)
            VALUES (?, ?, NOW(), ?, ?)";

    if ($stmt = mysqli_prepare($con, $sql)) {
        mysqli_stmt_bind_param($stmt, "ssss", $userindex, $caption, $path, $data_inf);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }
}

function respond($con, $userindex, $path, $code, $payload, $caption = null) {
    http_response_code($code);
    if ($caption !== null) {
        log_activity($con, $userindex, $caption, $path, json_encode($payload));
    }
    echo json_encode($payload);
    exit;
}

/* =========================
   METHOD + DB CHECK
========================= */
if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    if (isset($con) && $con) {
        log_activity($con, "UNKNOWN", "INVALID REQUEST METHOD", $path, json_encode([
            "method" => $_SERVER["REQUEST_METHOD"] ?? ""
        ]));
    }
    echo json_encode(["ok" => false, "message" => "Method not allowed"]);
    exit;
}

if (!isset($con) || !$con) {
    echo json_encode(["ok" => false, "message" => "Database connection failed"]);
    exit;
}

/* =========================
   READ JSON OR POST
========================= */
$raw  = file_get_contents("php://input");
$data = json_decode($raw, true);
$isJson = is_array($data);
$request = $isJson ? $data : $_POST;

// Inputs
$policy_number = trim((string)($request['policy_number'] ?? ""));
$mobil_no      = trim((string)($request['mobil_no'] ?? "")); // keep field name mobil_no

$userindex = ($mobil_no !== "") ? $mobil_no : "UNKNOWN";

// Log request received
log_activity($con, $userindex, "REQUEST RECEIVED", $path, json_encode([
    "policy_number" => $policy_number,
    "mobil_no" => $mobil_no
]));

/* =========================
   VALIDATION
========================= */
if ($policy_number === "" || $mobil_no === "") {
    respond($con, $userindex, $path, 400, [
        "ok" => false,
        "message" => "Missing required fields",
        "required" => ["policy_number", "mobil_no"]
    ], "VALIDATION FAILED (missing fields)");
}

/* =========================
   GET MANDATE ID (SAFE)
========================= */
$stmt = mysqli_prepare($con, "SELECT mandate_id FROM subscription_main WHERE policy_number = ? LIMIT 1");
if (!$stmt) {
    respond($con, $userindex, $path, 500, [
        "ok" => false,
        "message" => "Prepare failed (select mandate_id)",
        "details" => mysqli_error($con)
    ], "DB PREPARE FAILED (select mandate_id)");
}

mysqli_stmt_bind_param($stmt, "s", $policy_number);

if (!mysqli_stmt_execute($stmt)) {
    $err = mysqli_stmt_error($stmt);
    mysqli_stmt_close($stmt);
    respond($con, $userindex, $path, 500, [
        "ok" => false,
        "message" => "Execute failed (select mandate_id)",
        "details" => $err
    ], "DB EXECUTE FAILED (select mandate_id)");
}

$res = mysqli_stmt_get_result($stmt);
mysqli_stmt_close($stmt);

if (!$res || mysqli_num_rows($res) === 0) {
    respond($con, $userindex, $path, 404, [
        "ok" => false,
        "message" => "Policy not found or mandate_id missing",
        "policy_number" => $policy_number
    ], "MANDATE NOT FOUND");
}

$row = mysqli_fetch_assoc($res);
$mandate_id = trim((string)($row['mandate_id'] ?? ""));

if ($mandate_id === "") {
    respond($con, $userindex, $path, 404, [
        "ok" => false,
        "message" => "mandate_id is empty for this policy",
        "policy_number" => $policy_number
    ], "MANDATE EMPTY");
}

log_activity($con, $userindex, "MANDATE ID FETCHED", $path, json_encode([
    "policy_number" => $policy_number,
    "mandate_id" => $mandate_id
]));

/* =========================
   CANCEL MANDATE (GATEWAY)
========================= */
$merchantId = '1664';
$productId  = '3';
$clientPhone = $mobil_no;
$apiKey = "c1SpFDs1ONN0SjawWMkYawwOAWAAu2Lb";

$payload = [
    "merchantId" => $merchantId,
    "productId" => $productId,
    "clientPhone" => $clientPhone,
    "mandateId" => $mandate_id,
    "apiKey" => $apiKey
];

// Log outbound request (mask apiKey)
$payload_log = $payload;
$payload_log["apiKey"] = "***MASKED***";
log_activity($con, $userindex, "GATEWAY REQUEST PREPARED", $path, json_encode($payload_log));

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://ddv15-do.transflowitc.com/cancel/mandate",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 60,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_SSL_VERIFYHOST => 0,
    CURLOPT_SSL_VERIFYPEER => 0,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode($payload),
    CURLOPT_HTTPHEADER => [
        "cache-control: no-cache",
        "content-type: application/json"
    ],
]);

$response = curl_exec($curl);
$err      = curl_error($curl);
$httpCode = (int)curl_getinfo($curl, CURLINFO_HTTP_CODE);

curl_close($curl);

if ($err) {
    respond($con, $userindex, $path, 500, [
        "ok" => false,
        "message" => "cURL error",
        "details" => $err
    ], "CURL ERROR");
}

// Decode gateway response (if JSON)
$decoded = json_decode($response, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    log_activity($con, $userindex, "GATEWAY RESPONSE (NON-JSON)", $path, json_encode([
        "gateway_http_code" => $httpCode,
        "raw" => $response
    ]));

    respond($con, $userindex, $path, 200, [
        "ok" => true,
        "gateway_http_code" => $httpCode,
        "gateway_raw" => $response
    ], "SUCCESS (RAW GATEWAY RESPONSE)");
}

log_activity($con, $userindex, "GATEWAY RESPONSE (JSON)", $path, json_encode([
    "gateway_http_code" => $httpCode,
    "gateway_response" => $decoded
]));

// Return wrapped response
respond($con, $userindex, $path, 200, [
    "ok" => true,
    "gateway_http_code" => $httpCode,
    "gateway_response" => $decoded
], "SUCCESS (GATEWAY RESPONSE FORWARDED)");
?>