<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header("Content-Type: application/json; charset=utf-8");

include "database.php";
require_once "sms_function.php";

date_default_timezone_set("Africa/Accra");
$path = $_SERVER['REQUEST_URI'] ?? 'terms_condition.php';

/* =========================
   LOG FUNCTION
   Table: users_logs
   userindex = mobile_no
========================= */
function log_activity($con, $userindex, $caption, $path, $data_inf) {
    if (!isset($con) || !$con) return;

    $sql = "INSERT INTO users_logs (userindex, caption, logs_date, path, data_inf)
            VALUES (?, ?, NOW(), ?, ?)";

    if ($stmt = mysqli_prepare($con, $sql)) {
        mysqli_stmt_bind_param($stmt, "ssss", $userindex, $caption, $path, $data_inf);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }
}

function respond($con, $userindex, $path, $ok, $message, $extra = [], $caption = null) {
    if ($caption !== null) {
        log_activity($con, $userindex, $caption, $path, json_encode(array_merge([
            "ok" => $ok,
            "message" => $message
        ], $extra)));
    }

    echo json_encode(array_merge([
        "ok" => $ok,
        "message" => $message
    ], $extra));
    exit;
}

/* =========================
   FIX ✅: Accept BOTH JSON body and normal form/query params
   - USSD post_json(...) sends JSON -> php://input
   - Browser/tests may send ?mobile_no=...
========================= */
$rawBody = file_get_contents("php://input");
$body = json_decode($rawBody, true);
if (!is_array($body)) $body = [];

// Try common keys (your spec is mobile_no)
$mobile_no = trim((string)(
    $body["mobile_no"] ??
    $_REQUEST["mobile_no"] ??
    $body["mobile_number"] ??
    $_REQUEST["mobile_number"] ??
    $body["phoneNumber"] ??
    $_REQUEST["phoneNumber"] ??
    ""
));

$userindex = ($mobile_no !== "") ? $mobile_no : "UNKNOWN";

// ---- Validate DB ----
if (!isset($con) || !$con) {
    echo json_encode(["ok" => false, "message" => "Database connection failed"]);
    exit;
}

// Log request (include raw body for debugging)
log_activity($con, $userindex, "REQUEST RECEIVED", $path, json_encode([
    "mobile_no" => $mobile_no,
    "raw_body"  => $rawBody
]));

// ---- Validate input ----
if ($mobile_no === "") {
    respond(
        $con,
        $userindex,
        $path,
        false,
        "Mobile number is required",
        ["http_code" => 200],
        "VALIDATION FAILED"
    );
}

// ---- Normalize number (233XXXXXXXXX → 0XXXXXXXXX) ----
if (preg_match('/^233\d{9}$/', $mobile_no)) {
    $localNumber = "0" . substr($mobile_no, 3);
    log_activity($con, $userindex, "MOBILE NORMALIZED (233 -> 0)", $path, json_encode([
        "input" => $mobile_no,
        "normalized" => $localNumber
    ]));
} else {
    $localNumber = $mobile_no;
    log_activity($con, $userindex, "MOBILE NORMALIZED (fallback)", $path, json_encode([
        "input" => $mobile_no,
        "normalized" => $localNumber
    ]));
}

// ---- SMS payload ----
$user_id       = $mobile_no;   // since only mobile_no is passed
$mobile_number = $localNumber;
$message       = "Welcome to ImpactLife Insurance! Terms & Conditions: https://impactlife.com.gh/ImpactLife_TnC.pdf";
$message_type  = "T&C";

log_activity($con, $userindex, "SMS SEND ATTEMPT", $path, json_encode([
    "mobile_number" => $mobile_number,
    "message_type"  => $message_type
]));

// ---- Send SMS ----
$result = sendHubtelSms(
    $con,
    $user_id,
    $mobile_number,
    $message,
    $message_type
);

// ---- Handle response ----
if (!is_array($result)) {
    respond(
        $con,
        $userindex,
        $path,
        false,
        "SMS failed (invalid response)",
        ["raw_result" => $result, "http_code" => 200],
        "SMS FAILED"
    );
}

if (!empty($result['success'])) {
    respond(
        $con,
        $userindex,
        $path,
        true,
        "SMS sent successfully",
        ["response" => $result['response'] ?? null, "http_code" => 200],
        "SMS SENT SUCCESSFULLY"
    );
} else {
    respond(
        $con,
        $userindex,
        $path,
        false,
        "SMS failed",
        ["response" => $result['response'] ?? null, "http_code" => 200],
        "SMS FAILED"
    );
}
?>